/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.collector;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.machines.content.attachments.CollectorAttachment;
import tv.soaryn.xycraft.machines.content.blocks.collector.CollectorBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStatusColors;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class CollectorBlock
extends SidePartBlock.WithEntity
implements EntityBlock,
ITooltipProvider.BlockDefault {
    public CollectorBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().randomTicks(), CollectorBlockEntity::new);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Success)));
        this.registerSystem(MachinesSystems.Collector);
        this.registerHasCapability();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)Objects.requireNonNullElseGet(super.getStateForPlacement(ctx), () -> ((CollectorBlock)this).defaultBlockState()).setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Success))).setValue(MachineStateProperties.Status, (Comparable)((Object)(ctx.getLevel().hasNeighborSignal(ctx.getClickedPos()) ? MachineStatusColors.Off : MachineStatusColors.Success)));
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CollectorBlockEntity) {
            CollectorBlockEntity collector = (CollectorBlockEntity)blockEntity;
            level.playSound(null, pos, SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.05f, level.random.nextFloat() * 0.1f + 0.9f);
            if (!level.isClientSide() && !player.isFakePlayer()) {
                player.openMenu((MenuProvider)collector, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public boolean canConnectRedstone(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onPlace(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VolumeLevelAttachment.add((Level)serverLevel, (BlockPos)pos, MachinesAttachments.CollectorVolumeData);
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        BlockEntity blockEntity;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VolumeLevelAttachment.remove((Level)serverLevel, (BlockPos)pos, MachinesAttachments.CollectorVolumeData);
        }
        if (!state.is(oldState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof CollectorBlockEntity) {
            CollectorBlockEntity entity = (CollectorBlockEntity)blockEntity;
            CollectorAttachment data = (CollectorAttachment)entity.getData(MachinesAttachments.CollectorData);
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)data.Buffer.asVanillaContainer());
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)data.Inventory.asVanillaContainer());
        }
        super.onRemove(state, level, pos, oldState, moving);
    }

    protected void cleanRemove(ServerLevel level, BlockPos pos) {
        VolumeLevelAttachment.remove((Level)level, (BlockPos)pos, MachinesAttachments.CollectorVolumeData);
        super.cleanRemove(level, pos);
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(CollectorBlockEntity::onItemEntityForm);
        NeoForge.EVENT_BUS.addListener(CollectorBlockEntity::onItemTick);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MachineStateProperties.Status});
    }

    public VoxelShape getDownShapeForBaking() {
        VoxelShape node = CollectorBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
        VoxelShape port = CollectorBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
        VoxelShape base = CollectorBlock.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
        return Shapes.or((VoxelShape)node, (VoxelShape[])new VoxelShape[]{port, base});
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean p_60514_) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, p_60514_);
        MachineStatusColors currentStatus = (MachineStatusColors)((Object)state.getValue(MachineStateProperties.Status));
        BlockEntity collector = level.getBlockEntity(pos);
        if (collector == null) {
            return;
        }
        CollectorAttachment data = (CollectorAttachment)collector.getData(MachinesAttachments.CollectorData);
        if (level.hasNeighborSignal(pos)) {
            if (currentStatus == MachineStatusColors.Off) {
                return;
            }
            BlockState newState = (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Off));
            level.setBlockAndUpdate(pos, newState);
            level.markAndNotifyBlock(pos, level.getChunkAt(pos), newState, newState, 3, 512);
        } else if (currentStatus == MachineStatusColors.Off) {
            boolean isFull = false;
            SimpleItemContainer tempInventory = new SimpleItemContainer(data.Inventory.size());
            for (int i = 0; i < tempInventory.size(); ++i) {
                tempInventory.set(i, data.Inventory.get(i));
            }
            IItemHandlerModifiable tempHandler = tempInventory.asHandler();
            boolean checkForEmpty = false;
            for (ItemStack itemStack : data.Buffer) {
                ItemStack remaining;
                if (itemStack.isEmpty()) {
                    isFull = false;
                    break;
                }
                if (checkForEmpty || (remaining = ItemHandlerHelper.insertItem((IItemHandler)tempHandler, (ItemStack)itemStack, (boolean)false)).isEmpty()) continue;
                checkForEmpty = true;
                isFull = true;
            }
            BlockState newState = (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)(isFull ? MachineStatusColors.Idle : MachineStatusColors.Success)));
            level.setBlockAndUpdate(pos, newState);
            level.markAndNotifyBlock(pos, level.getChunkAt(pos), newState, newState, 3, 512);
        }
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, context) -> {
            if (blockEntity == null || CollectorBlock.isInaccessibleSide((Direction)context, (BlockState)state)) {
                return null;
            }
            return ((CollectorAttachment)blockEntity.getData(MachinesAttachments.CollectorData)).Inventory.asHandler(new HandlerIOBehavior(){

                public boolean canInsert(int slot) {
                    return false;
                }
            });
        }, new Block[]{MachinesContent.Block.Collector.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.Collector.block()});
    }
}

