/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.IColorable;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.content.attachments.InventoryAttachment;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.ColorableCapability;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.systems.MachinesSounds;
import tv.soaryn.xycraft.machines.gui.SoarynBoxMenu;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class SoarynBoxBlock
extends XyBlock.WithEntity
implements IColoredBlock,
ITooltipProvider.BlockDefault {
    private static final VoxelShape Shape = Shapes.join((VoxelShape)SoarynBoxBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (VoxelShape)SoarynBoxBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.NOT_SAME);

    public SoarynBoxBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion(), Entity::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.ActiveSideDown, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideUp, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideNorth, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideSouth, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideWest, (Comparable)Boolean.valueOf(true))).setValue((Property)CoreStateProperties.ActiveSideEast, (Comparable)Boolean.valueOf(true)));
        this.registerHasCapability();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CoreStateProperties.ActiveSideDown});
        builder.add(new Property[]{CoreStateProperties.ActiveSideUp});
        builder.add(new Property[]{CoreStateProperties.ActiveSideNorth});
        builder.add(new Property[]{CoreStateProperties.ActiveSideSouth});
        builder.add(new Property[]{CoreStateProperties.ActiveSideWest});
        builder.add(new Property[]{CoreStateProperties.ActiveSideEast});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shape;
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof Entity)) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        Entity entity = (Entity)be;
        level.playSound(null, pos, SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.05f, level.random.nextFloat() * 0.1f + 0.9f);
        if (!level.isClientSide() && !player.isFakePlayer()) {
            player.openMenu((MenuProvider)entity, be.getBlockPos());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        BlockEntity blockEntity;
        Player player;
        block10: {
            block9: {
                super.setPlacedBy(level, pos, state, entity, stack);
                if (!(entity instanceof Player)) break block9;
                player = (Player)entity;
                blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof Entity) break block10;
            }
            return;
        }
        Entity box = (Entity)blockEntity;
        DyeColor dye = DyeColor.getColor((ItemStack)player.getOffhandItem());
        IColorable cap = ColorableCapability.of((Level)level, (BlockPos)pos);
        if (cap != null) {
            cap.setColor(0, dye == null ? FavoredColor.of((IAttachmentHolder)player) : ColorUtils.getColorFromDye((DyeColor)dye));
            box.setChanged();
        }
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA)) {
            return;
        }
        if (!level.isClientSide() && ModifierKey.of((Player)player)) {
            InventoryAttachment data = (InventoryAttachment)box.getData(MachinesAttachments.SoarynBoxData);
            Inventory inventory = player.getInventory();
            ItemContainer boxInv = data.Inventory;
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            for (int i = 9; i < inventory.items.size(); ++i) {
                itemList.add(inventory.removeItem(i, 64));
            }
            itemList.sort(Comparator.comparing(ItemStack::getDescriptionId));
            if (itemList.stream().anyMatch(Predicate.not(ItemStack::isEmpty))) {
                float r = Mth.clamp((float)(level.getRandom().nextFloat() - 0.5f), (float)-0.01f, (float)0.1f);
                level.playSound(null, pos, (SoundEvent)MachinesSounds.SoarynBoxDeposit.value(), SoundSource.PLAYERS, 0.5f, 1.0f + r);
            }
            for (ItemStack itemStack : itemList) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)boxInv.asHandler(), (ItemStack)itemStack, (boolean)false);
            }
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof Entity) {
            Entity entity = (Entity)blockEntity;
            InventoryAttachment data = (InventoryAttachment)entity.getData(MachinesAttachments.SoarynBoxData);
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)data.Inventory.asVanillaContainer());
        }
        super.onRemove(state, level, pos, newState, moving);
    }

    @SubscribeEvent
    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, context) -> {
            if (blockEntity == null || context != null && !((Boolean)state.getValue((Property)CoreStateProperties.ActiveSideMap.get(context))).booleanValue()) {
                return null;
            }
            return ((InventoryAttachment)blockEntity.getData(MachinesAttachments.SoarynBoxData)).Handler;
        }, new Block[]{MachinesContent.Block.SoarynBox.block()});
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, ColorableCapability::registerBlock, new Block[]{MachinesContent.Block.SoarynBox.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, (level, pos, state, blockEntity, context) -> (player, interactionHand, hitResult) -> {
            BlockState state2 = level.getBlockState(pos);
            level.setBlockAndUpdate(pos, (BlockState)state2.cycle((Property)CoreStateProperties.ActiveSideMap.get(hitResult.getDirection())));
            level.invalidateCapabilities(pos);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }, new Block[]{MachinesContent.Block.SoarynBox.block()});
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        if (level == null) {
            return super.getColorOfBlock(state, level, pos, index);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return super.getColorOfBlock(state, level, pos, index);
        }
        return FavoredColor.of((IAttachmentHolder)blockEntity);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return FavoredColor.of((IAttachmentHolder)Utils.getClientPlayer());
    }

    public static class Entity
    extends XyBlockEntity.WithMenu {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.SoarynBox.entity(), "block.xycraft_machines.soaryn_box", pos, state, new AttachmentType[]{(AttachmentType)CoreAttachments.Color.get(), MachinesAttachments.SoarynBoxData.get()});
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
            return new SoarynBoxMenu(windowId, playerInventory, (BlockEntity)this, ((InventoryAttachment)this.getData(MachinesAttachments.SoarynBoxData)).Inventory);
        }
    }
}

