/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.volumes.IlluminationVolume;
import tv.soaryn.xycraft.machines.network.CBLightVolumePacket;
import tv.soaryn.xycraft.machines.utils.mixins.ILevelLightEngineMix;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public class IlluminationFieldBlock
extends SidePartBlock
implements ITooltipProvider.BlockDefault {
    public IlluminationFieldBlock(BlockBehaviour.Properties properties) {
        super(properties.requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get()));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(15)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.LEVEL});
    }

    public VoxelShape getDownShapeForBaking() {
        return IlluminationFieldBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (state == null) {
            return null;
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(15 - ctx.getLevel().getBestNeighborSignal(ctx.getClickedPos())));
    }

    public void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean p_54758_) {
        VolumeLevelAttachment.add((Level)level, (BlockPos)pos, MachinesAttachments.IlluminationVolumeData);
        if (newState.is(blockState.getBlock())) {
            return;
        }
        CBLightVolumePacket.broadcast(level, pos, CBLightVolumePacket.VolumeAction.Add, true);
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource randSource) {
        super.tick(state, level, pos, randSource);
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)level, IlluminationVolume.class);
        List<BlockPos> positions = lookup.getAllBoxes(pos).toList();
        ILevelLightEngineMix mix = ILevelLightEngineMix.of((Level)level);
        positions.forEach(mix::xycraft$checkVolume);
        CBLightVolumePacket.broadcast((Level)level, pos, CBLightVolumePacket.VolumeAction.Update, true);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onRemove(state, level, pos, oldState, moving);
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)level, IlluminationVolume.class);
        List<BlockPos> positions = lookup.getAllBoxes(pos).toList();
        VolumeLevelAttachment.remove((Level)level, (BlockPos)pos, MachinesAttachments.IlluminationVolumeData);
        ILevelLightEngineMix mix = ILevelLightEngineMix.of(level);
        positions.forEach(mix::xycraft$checkVolume);
        if (!oldState.is(state.getBlock())) {
            CBLightVolumePacket.broadcast(level, pos, CBLightVolumePacket.VolumeAction.Remove, true);
        }
    }

    @SubscribeEvent
    private static void chunkSent(ChunkWatchEvent.Sent event) {
        ServerLevel level = event.getLevel();
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)level, IlluminationVolume.class);
        FastVolumeLookup.ChunkVolumeData volumes = lookup.getVolumesForChunk(ChunkPos.asLong((int)event.getPos().x, (int)event.getPos().z));
        if (volumes == null) {
            return;
        }
        volumes.getAll().map(IlluminationVolume::getPos).forEach(pos -> CBLightVolumePacket.broadcast((Level)level, pos, CBLightVolumePacket.VolumeAction.Add, false));
    }

    public void neighborChanged(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighborPos, boolean isMoving) {
        super.neighborChanged(blockState, level, pos, block, neighborPos, isMoving);
        Integer current = (Integer)blockState.getValue((Property)BlockStateProperties.LEVEL);
        int highest = 15 - level.getBestNeighborSignal(pos);
        if (current == highest) {
            return;
        }
        level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(highest)));
    }
}

