/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.Arrays;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNodeClient;
import tv.soaryn.xycraft.api.content.capabilities.SimpleXynergyNode;
import tv.soaryn.xycraft.api.content.xynergy.XynergyNet;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class HoverPylonBlock
extends SidePartBlock
implements IColoredBlock {
    public static final Vector3f[] hoverPylonRenderOffsets = (Vector3f[])Util.make((Object)new Vector3f[6], array -> Arrays.setAll(array, i -> {
        Vector3f offset = new Vector3f(0.0f, 0.65f, 0.0f);
        Direction dir = Direction.from3DDataValue((int)i);
        Vec3i normal = dir.getNormal();
        return offset.rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, -1.0f, 0.0f, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ()));
    }));

    public HoverPylonBlock(BlockBehaviour.Properties properties) {
        super(properties.requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get()).noOcclusion());
    }

    public VoxelShape getDownShapeForBaking() {
        double min = 4.25829;
        double max = 16.0 - min;
        return Shapes.or((VoxelShape)HoverPylonBlock.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), (VoxelShape)HoverPylonBlock.box((double)min, (double)0.0, (double)min, (double)max, (double)5.0, (double)max));
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onPlace(state, level, pos, oldState, moving);
        if (oldState.is(state.getBlock())) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VolumeLevelAttachment.add((Level)serverLevel, (BlockPos)pos, MachinesAttachments.HoverVolumeData);
        }
        level.invalidateCapabilities(pos);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moving) {
        super.onRemove(state, level, pos, newState, moving);
        if (newState.is(state.getBlock())) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VolumeLevelAttachment.remove((Level)serverLevel, (BlockPos)pos, MachinesAttachments.HoverVolumeData);
        }
        level.invalidateCapabilities(pos);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return -14505370;
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlock(CoreCapabilities.XynergyNode.BLOCK, (level, pos, state, blockEntity, context) -> new SimpleXynergyNode(XynergyNet.xynergyUnit((long)-4L), 4, 16), new Block[]{MachinesContent.Block.HoverPylon.block()});
        event.registerBlock(CoreCapabilities.XynergyNode.BLOCK_CLIENT, (level, pos, state, blockEntity, context) -> new IXynergyNodeClient(){

            @NotNull
            public Vector3f getRenderOffset(BlockPos otherNode) {
                return hoverPylonRenderOffsets[((Direction)level.getBlockState(pos).getValue((Property)CoreStateProperties.StateDirection)).get3DDataValue()];
            }

            public boolean hasRenderNode(BlockPos otherNode) {
                return true;
            }

            public int getColor() {
                return 857918617;
            }
        }, new Block[]{MachinesContent.Block.HoverPylon.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.HoverPylon.block()});
    }
}

