/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.client.render.FluidRenderer;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.resources.FluidUtils;
import tv.soaryn.xycraft.machines.client.multiblock.ClientTankEventHandler;
import tv.soaryn.xycraft.machines.client.multiblock.ClientTankMultiBlock;

public class TankMultiBlockRenderer {
    public static void onRenderLevel(RenderLevelStageEvent event) {
        double viewDistance;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        double chunkDist = event.getLevelRenderer().getLastViewDistance();
        double bound = viewDistance = chunkDist * 16.0 + 36.0;
        bound *= bound;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        level.getProfiler().push("xycraft_machines:tank_fluid_render");
        MultiBufferSource.BufferSource renderBuffers = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 cameraPos = event.getCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        for (ClientTankMultiBlock tank : ClientTankEventHandler.getAllTanks()) {
            TankMultiBlockRenderer.renderFluid(event, level, chunkDist, viewDistance, bound, renderBuffers, cameraPos, poseStack, tank);
        }
        renderBuffers.endBatch();
        level.getProfiler().pop();
    }

    private static void renderFluid(RenderLevelStageEvent event, @NotNull ClientLevel level, double chunkDist, double viewDistance, double bound, MultiBufferSource.BufferSource renderBuffers, Vec3 cameraPos, PoseStack poseStack, ClientTankMultiBlock tank) {
        double fluidAmount = tank.getFluidAmount(event.getPartialTick().getGameTimeDeltaPartialTick(false));
        if (fluidAmount == 0.0) {
            return;
        }
        BlockPos min = tank.getInnerMin();
        BlockPos size = tank.getInnerMax().subtract((Vec3i)min).offset(1, 1, 1);
        Vec3i halfSize = new Vec3i(size.getX() / 2, size.getY() / 2, size.getZ() / 2);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)min.offset(halfSize));
        double dist = cameraPos.distanceToSqr(min.offset(halfSize).getCenter());
        if (dist > bound) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate((double)min.getX() - cameraPos.x(), (double)min.getY() - cameraPos.y(), (double)min.getZ() - cameraPos.z());
        float floatOffset = (float)dist / 100000.0f;
        double alpha = Math.max(0.0, (viewDistance -= 12.0 + chunkDist) * viewDistance / 5.0 / dist);
        alpha = Math.min(alpha, 1.0);
        FluidStack fluid = tank.getFluidType();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        Vector4f color = ColorUtils.convertToRGBAVec((int)clientFluid.getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)level, new BlockPos((Vec3i)min.offset(halfSize))));
        if (FluidUtils.isGas((FluidStack)fluid)) {
            color.w = (float)fluidAmount * 0.5f + 0.5f;
            FluidRenderer.renderFluidBox((FluidStack)fluid, (float)floatOffset, (float)floatOffset, (float)floatOffset, (float)((float)size.getX() - floatOffset), (float)((float)size.getY() - floatOffset), (float)((float)size.getZ() - floatOffset), (MultiBufferSource)renderBuffers, (PoseStack)poseStack, (int)ColorUtils.convertToARGB((Vector4f)color), (int)light, (boolean)true);
        } else {
            color.w = (float)alpha;
            FluidRenderer.renderFluidBox((FluidStack)fluid, (float)floatOffset, (float)floatOffset, (float)floatOffset, (float)((float)size.getX() - floatOffset), (float)((float)Math.max((double)size.getY() * fluidAmount, (double)floatOffset)), (float)((float)size.getZ() - floatOffset), (MultiBufferSource)renderBuffers, (PoseStack)poseStack, (int)ColorUtils.convertToARGB((Vector4f)color), (int)light, (boolean)true);
        }
        poseStack.popPose();
    }

    public static void onDrawHighlight(RenderHighlightEvent.Block event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null && minecraft.player.isSecondaryUseActive() || KeyConflictContext.IN_GAME.isActive() && ModifierKey.of((Player)minecraft.player)) {
            return;
        }
        ClientTankMultiBlock multiBlock = ClientTankEventHandler.getLookedAt((Level)minecraft.level, event.getTarget().getBlockPos());
        if (multiBlock == null) {
            return;
        }
        Vec3 cameraPos = event.getCamera().getPosition();
        LevelRenderer.renderVoxelShape((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().getBuffer(RenderType.lines()), (VoxelShape)multiBlock.getShape(), (double)(-cameraPos.x()), (double)(-cameraPos.y()), (double)(-cameraPos.z()), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f, (boolean)true);
        event.setCanceled(true);
    }
}

