/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.weapons;

import com.sammy.malum.common.data.attachment.StaffAbilityData;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectType;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class SwiftSpiralItem
extends AbstractStaffItem
implements IMalumEventResponder,
ISpiritAffiliatedItem,
ItemSubPredicate {
    public SwiftSpiralItem(Tier tier, float magicDamage, float chargeDuration, int chargeCapacity, LodestoneItemProperties properties) {
        super(tier, magicDamage, chargeDuration, chargeCapacity, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnChargeParticles(Level pLevel, LivingEntity pLivingEntity, Vec3 pos, ItemStack pStack, float pct) {
    }

    public int getProjectileCount(Level level, LivingEntity livingEntity, float pct) {
        return 0;
    }

    public void fireProjectile(LivingEntity player, ItemStack stack, Level level, InteractionHand hand, int count) {
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect((String)"swift_spiral_tooltip", (Object[])new Object[0])});
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        DamageSource source = event.getSource();
        boolean canTriggerMagic = source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC);
        if (canTriggerMagic && target.isAlive()) {
            float attackDamage = (float)attacker.getAttributes().getValue(Attributes.ATTACK_DAMAGE);
            target.invulnerableTime = 0;
            target.hurt(DamageTypeHelper.create((Level)target.level(), (ResourceKey)MalumDamageTypes.TYRVING, (Entity)attacker), attackDamage * 0.75f);
            target.hurtMarked = true;
            WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker).setDamageData(MalumDamageTypes.SCYTHE_MELEE, 0.0f, MalumDamageTypes.TYRVING, 0.0f, 1).setImpactParticleEffect((NetworkedParticleEffectType)MalumParticleEffectTypes.SUNDERING_ANCHOR_SWEEP, new MalumNetworkedParticleEffectColorData(new MalumSpiritType[]{MalumSpiritTypes.EARTHEN_SPIRIT})).setSound((Holder)MalumSoundEvents.SCYTHE_CUT, 1.25f, 1.5f, 0.7f));
        }
    }

    public MalumSpiritType getDefiningSpiritType() {
        return MalumSpiritTypes.INFERNAL_SPIRIT;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return itemAbility.equals(ItemAbilities.SWORD_DIG);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        StaffAbilityData data;
        float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
        ItemStack itemstack = player.getItemInHand(hand);
        float duration = (float)player.getAttributes().getValue((Holder)MalumAttributes.CHARGE_DURATION);
        if (!player.getAbilities().instabuild && !(data = (StaffAbilityData)player.getData(MalumAttachmentTypes.STAFF_ABILITIES)).canUseStaff((LivingEntity)player)) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (duration >= 0.0f) {
            Vec3 lookVec = player.getLookAngle();
            double speed = 3.0;
            player.setDeltaMovement(lookVec.scale(speed));
            player.hurtMarked = true;
            player.hasImpulse = true;
            player.startAutoSpinAttack(20, 10.0f, itemstack);
            StaffAbilityData data2 = (StaffAbilityData)player.getData(MalumAttachmentTypes.STAFF_ABILITIES);
            data2.consumeStaffCharge((LivingEntity)player);
        }
        return InteractionResultHolder.success((Object)itemstack);
    }

    public boolean matches(ItemStack itemStack) {
        return false;
    }
}

