/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.weapons;

import com.sammy.malum.common.data.attachment.StaffAbilityData;
import com.sammy.malum.common.entity.bolt.HexBoltEntity;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.strawberry.gaze.registry.GazeDataComponents;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectType;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class SpiritSaberItem
extends AbstractStaffItem
implements IMalumEventResponder,
ISpiritAffiliatedItem,
ItemSubPredicate {
    public SpiritSaberItem(Tier tier, float magicDamage, float chargeDuration, int chargeCapacity, LodestoneItemProperties properties) {
        super(tier, magicDamage, chargeDuration, chargeCapacity, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnChargeParticles(Level pLevel, LivingEntity pLivingEntity, Vec3 pos, ItemStack pStack, float pct) {
        RandomSource random = pLevel.random;
        WorldParticleBuilder.create((Supplier)MalumParticles.SLASH).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)pLivingEntity.getLookAngle().normalize())).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.1f, (float)0.2f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)-0.314f, (float)0.314f)).build()).setTransparencyData(GenericParticleData.create((float)(0.5f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)(0.3f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setMotion(pLivingEntity.getLookAngle().normalize().scale((double)(0.2f * pct))).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setColorData(MalumSpiritTypes.ELDRITCH_SPIRIT.createColorData().build()).enableForcedSpawn().setLifeDelay(2).setLifetime(5).enableNoClip().spawn(pLevel, pos.x, pos.y, pos.z).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.x, pos.y, pos.z);
    }

    public int getProjectileCount(Level level, LivingEntity livingEntity, float pct) {
        return 1;
    }

    public void fireProjectile(LivingEntity player, ItemStack stack, Level level, InteractionHand hand, int count) {
        int ceil = Mth.ceil((float)((float)count / 2.0f));
        int spawnDelay = 1 + ceil * 2;
        float spread = count > 0 ? (float)(ceil %= 7) * 0.1f * (float)((long)count % 2L == 0L ? 1 : -1) : 0.0f;
        float pitchOffset = count > 4 ? 2.0f + (2.0f - (float)ceil * 1.5f) : 0.5f;
        float velocity = 3.0f;
        float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
        Vec3 pos = this.getProjectileSpawnPos(player, hand, 0.5f, 0.5f);
        HexBoltEntity entity = new HexBoltEntity(level, pos.x, pos.y, pos.z);
        entity.setData(player, magicDamage, spawnDelay);
        entity.setItem(stack);
        entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -pitchOffset, velocity, 0.0f);
        Vec3 projectileDirection = entity.getDeltaMovement();
        float yRot = (float)(Mth.atan2((double)projectileDirection.x, (double)projectileDirection.z) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
        entity.setDeltaMovement(entity.getDeltaMovement().add(left.scale((double)spread)));
        level.addFreshEntity((Entity)entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect((String)"spirit_saber_tooltip", (Object[])new Object[0])});
    }

    public MalumSpiritType getDefiningSpiritType() {
        return MalumSpiritTypes.INFERNAL_SPIRIT;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return itemAbility.equals(ItemAbilities.SWORD_DIG);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String spirit = (String)stack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get());
        tooltip.add((Component)Component.literal((String)("Spirit: " + (spirit != null ? spirit : "None"))));
    }

    public static MalumSpiritType getSpiritTypeFromOffhand(LivingEntity entity) {
        Item offhand = entity.getOffhandItem().getItem();
        if (offhand == MalumSpiritTypes.SACRED_SPIRIT.getSpiritShard()) {
            return MalumSpiritTypes.SACRED_SPIRIT;
        }
        if (offhand == MalumSpiritTypes.WICKED_SPIRIT.getSpiritShard()) {
            return MalumSpiritTypes.WICKED_SPIRIT;
        }
        if (offhand == MalumSpiritTypes.ARCANE_SPIRIT.getSpiritShard()) {
            return MalumSpiritTypes.ARCANE_SPIRIT;
        }
        if (offhand == MalumSpiritTypes.ELDRITCH_SPIRIT.getSpiritShard()) {
            return MalumSpiritTypes.ELDRITCH_SPIRIT;
        }
        if (offhand == MalumSpiritTypes.AERIAL_SPIRIT.getSpiritShard()) {
            return MalumSpiritTypes.AERIAL_SPIRIT;
        }
        if (offhand == MalumSpiritTypes.AQUEOUS_SPIRIT.getSpiritShard()) {
            return MalumSpiritTypes.AQUEOUS_SPIRIT;
        }
        if (offhand == MalumSpiritTypes.EARTHEN_SPIRIT.getSpiritShard()) {
            return MalumSpiritTypes.EARTHEN_SPIRIT;
        }
        if (offhand == MalumSpiritTypes.INFERNAL_SPIRIT.getSpiritShard()) {
            return MalumSpiritTypes.INFERNAL_SPIRIT;
        }
        if (offhand == MalumSpiritTypes.UMBRAL_SPIRIT.getSpiritShard()) {
            return MalumSpiritTypes.UMBRAL_SPIRIT;
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Item item;
        ItemStack mainStack = player.getItemInHand(hand);
        ItemStack offhandStack = player.getOffhandItem();
        if (!level.isClientSide && !offhandStack.isEmpty() && (item = offhandStack.getItem()) instanceof SpiritShardItem) {
            SpiritShardItem shard = (SpiritShardItem)item;
            if (shard == MalumSpiritTypes.UMBRAL_SPIRIT.getSpiritShard()) {
                return InteractionResultHolder.success((Object)mainStack);
            }
            offhandStack.shrink(1);
            CompoundTag tag = new CompoundTag();
            String spiritId = shard.toString();
            tag.putString("ActiveSpirit", spiritId);
            mainStack.set(GazeDataComponents.ACTIVE_SPIRIT, (Object)spiritId);
            return InteractionResultHolder.success((Object)mainStack);
        }
        if (Objects.equals(mainStack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get()), "malum:eldritch_spirit")) {
            StaffAbilityData data;
            ItemStack itemstack = player.getItemInHand(hand);
            float duration = (float)player.getAttributes().getValue((Holder)MalumAttributes.CHARGE_DURATION);
            if (!player.getAbilities().instabuild && !(data = (StaffAbilityData)player.getData(MalumAttachmentTypes.STAFF_ABILITIES)).canUseStaff((LivingEntity)player)) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (duration <= 0.0f) {
                    this.shoot(itemstack, serverLevel, (LivingEntity)player, this.getProjectileCount(level, (LivingEntity)player, 1.0f));
                }
            }
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.success((Object)mainStack);
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        DamageSource source = event.getSource();
        boolean canTriggerMagic = source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC);
        if (canTriggerMagic && target.isAlive()) {
            float attackDamage = (float)attacker.getAttributes().getValue(Attributes.ATTACK_DAMAGE);
            float magicDamage = (float)attacker.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
            if (Objects.equals(stack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get()), "malum:infernal_spirit")) {
                ItemStack itemstack = attacker.getItemInHand(InteractionHand.MAIN_HAND);
                if (!target.level().isClientSide && target.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                    target.removeEffect(MobEffects.FIRE_RESISTANCE);
                }
            }
            if (Objects.equals(stack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get()), "malum:arcane_spirit")) {
                if (target.isAlive()) {
                    target.invulnerableTime = 0;
                    target.hurt(DamageTypeHelper.create((Level)target.level(), (ResourceKey)MalumDamageTypes.TYRVING, (Entity)attacker), magicDamage * 1.5f);
                }
                WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker).setDamageData(MalumDamageTypes.SCYTHE_MELEE, 0.0f, MalumDamageTypes.TYRVING, 0.0f, 1).setImpactParticleEffect((NetworkedParticleEffectType)MalumParticleEffectTypes.SUNDERING_ANCHOR_SWEEP, new MalumNetworkedParticleEffectColorData(new MalumSpiritType[]{MalumSpiritTypes.ARCANE_SPIRIT})).setSound((Holder)MalumSoundEvents.SCYTHE_CUT, 1.25f, 1.5f, 0.7f));
            }
            if (Objects.equals(stack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get()), "malum:wicked_spirit")) {
                if (target.isAlive()) {
                    target.invulnerableTime = 0;
                    target.hurt(DamageTypeHelper.create((Level)target.level(), (ResourceKey)MalumDamageTypes.TYRVING, (Entity)attacker), attackDamage * 1.5f);
                }
                WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker).setDamageData(MalumDamageTypes.SCYTHE_MELEE, 0.0f, MalumDamageTypes.TYRVING, 0.0f, 1).setImpactParticleEffect((NetworkedParticleEffectType)MalumParticleEffectTypes.SUNDERING_ANCHOR_SWEEP, new MalumNetworkedParticleEffectColorData(new MalumSpiritType[]{MalumSpiritTypes.WICKED_SPIRIT})).setSound((Holder)MalumSoundEvents.SCYTHE_CUT, 1.25f, 1.5f, 0.7f));
            }
            if (Objects.equals(stack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get()), "malum:sacred_spirit")) {
                attacker.heal(1.0f);
            }
            if (Objects.equals(stack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get()), "malum:aqueous_spirit") && target.isInWaterOrRain()) {
                if (target.isAlive()) {
                    target.invulnerableTime = 0;
                    target.hurt(DamageTypeHelper.create((Level)target.level(), (ResourceKey)MalumDamageTypes.TYRVING, (Entity)attacker), attackDamage);
                    target.invulnerableTime = 0;
                    target.hurt(DamageTypeHelper.create((Level)target.level(), (ResourceKey)MalumDamageTypes.TYRVING, (Entity)attacker), magicDamage);
                }
                WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker).setDamageData(MalumDamageTypes.SCYTHE_MELEE, 0.0f, MalumDamageTypes.TYRVING, 0.0f, 1).setImpactParticleEffect((NetworkedParticleEffectType)MalumParticleEffectTypes.SUNDERING_ANCHOR_SWEEP, new MalumNetworkedParticleEffectColorData(new MalumSpiritType[]{MalumSpiritTypes.AQUEOUS_SPIRIT})).setSound((Holder)MalumSoundEvents.SCYTHE_CUT, 1.25f, 1.5f, 0.7f));
            }
            if (Objects.equals(stack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get()), "malum:aerial_spirit")) {
                double upwardVelocity = 1.0;
                target.hurtMarked = true;
                target.setDeltaMovement(target.getDeltaMovement().x, target.getDeltaMovement().y + upwardVelocity, target.getDeltaMovement().z);
                target.hasImpulse = true;
            }
            if (Objects.equals(stack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get()), "malum:earthen_spirit") && target.isBlocking()) {
                target.stopUsingItem();
                if (target instanceof Player) {
                    Player player = (Player)target;
                    player.getCooldowns().addCooldown(player.getUseItem().getItem(), 100);
                }
            }
        }
    }

    public boolean matches(ItemStack itemStack) {
        return false;
    }
}

