/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.curios.runes;

import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.SoulWardDamageEvent;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.strawberry.gaze.GazeMod;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class RuneEirItem
extends AbstractRuneCurioItem
implements IMalumEventResponder {
    private static final ResourceLocation EIR_BOOST_ID = GazeMod.gazePath("eir_rune");
    private static final WeakHashMap<LivingEntity, Integer> boostTimers = new WeakHashMap();

    public RuneEirItem(Item.Properties builder) {
        super(builder, MalumSpiritTypes.AERIAL_SPIRIT);
    }

    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect((String)"rune_of_eir", (Object[])new Object[0]));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        AttributeInstance attribute = entity.getAttribute((Holder)MalumAttributes.SOUL_WARD_RECOVERY_RATE);
        if (attribute != null) {
            attribute.removeModifier(EIR_BOOST_ID);
        }
        boostTimers.remove(entity);
    }

    public void soulWardDamageEvent(SoulWardDamageEvent event, LivingEntity entity, ItemStack stack) {
        AttributeInstance attribute;
        if (event.getSoulWardHandler().isDepleted() && (attribute = entity.getAttribute((Holder)MalumAttributes.SOUL_WARD_RECOVERY_RATE)) != null && attribute.getModifier(EIR_BOOST_ID) == null) {
            attribute.addTransientModifier(new AttributeModifier(EIR_BOOST_ID, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            boostTimers.put(entity, 300);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        boostTimers.entrySet().removeIf(entry -> {
            LivingEntity entity = (LivingEntity)entry.getKey();
            int timeLeft = (Integer)entry.getValue() - 1;
            if (timeLeft <= 0) {
                AttributeInstance attribute = entity.getAttribute((Holder)MalumAttributes.SOUL_WARD_RECOVERY_RATE);
                if (attribute != null) {
                    attribute.removeModifier(EIR_BOOST_ID);
                }
                return true;
            }
            entry.setValue(timeLeft);
            return false;
        });
    }
}

