/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze;

import com.mojang.logging.LogUtils;
import com.sammy.malum.common.item.GeasItem;
import com.sammy.malum.common.item.curiosities.TemporarilyDisabledItem;
import com.sammy.malum.registry.common.item.MalumItemTiers;
import com.sammy.malum.registry.common.item.MalumItems;
import com.strawberry.gaze.Config;
import com.strawberry.gaze.client.renderer.WheelCurioRenderer;
import com.strawberry.gaze.common.event.GazeEvents;
import com.strawberry.gaze.common.item.codex.EncyclopediaGazeItem;
import com.strawberry.gaze.common.item.curiosities.curios.brooches.CurioSluggishBrooch;
import com.strawberry.gaze.common.item.curiosities.curios.head.CurioAdaptiveResistanceWheel;
import com.strawberry.gaze.common.item.curiosities.curios.necklaces.CurioChargeNecklace;
import com.strawberry.gaze.common.item.curiosities.curios.rings.CurioCompromiseRing;
import com.strawberry.gaze.common.item.curiosities.curios.rings.CurioMeditationRing;
import com.strawberry.gaze.common.item.curiosities.curios.runes.RuneBlightedItem;
import com.strawberry.gaze.common.item.curiosities.curios.runes.RuneEirItem;
import com.strawberry.gaze.common.item.curiosities.curios.runes.RuneFafnirItem;
import com.strawberry.gaze.common.item.curiosities.curios.runes.RuneGymirItem;
import com.strawberry.gaze.common.item.curiosities.curios.runes.RunePhaseItem;
import com.strawberry.gaze.common.item.curiosities.curios.runes.RuneVeilItem;
import com.strawberry.gaze.common.item.curiosities.curios.runes.RuneVoidItem;
import com.strawberry.gaze.common.item.curiosities.curios.runes.RuneYmirItem;
import com.strawberry.gaze.common.item.curiosities.weapons.AstralSplinteredWorld;
import com.strawberry.gaze.common.item.curiosities.weapons.SeidhrItem;
import com.strawberry.gaze.common.item.curiosities.weapons.SoulRapierItem;
import com.strawberry.gaze.common.item.curiosities.weapons.SpiritSaberItem;
import com.strawberry.gaze.common.item.curiosities.weapons.SplinteredWorld;
import com.strawberry.gaze.common.item.curiosities.weapons.SwiftSpiralItem;
import com.strawberry.gaze.common.item.curiosities.weapons.VeilDaggerItem;
import com.strawberry.gaze.core.handlers.JoyfulEffectHandler;
import com.strawberry.gaze.core.handlers.SpiritSaberPredicate;
import com.strawberry.gaze.effect.BlightedEffect;
import com.strawberry.gaze.effect.CompromisedEffect;
import com.strawberry.gaze.effect.DrenchedEffect;
import com.strawberry.gaze.effect.JoyfulEffect;
import com.strawberry.gaze.effect.WorldAnchorEffect;
import com.strawberry.gaze.registry.CreativeTabRegistry;
import com.strawberry.gaze.registry.GazeDataComponents;
import com.strawberry.gaze.registry.GazeEntityRegistry;
import com.strawberry.gaze.registry.GazeGeasEffectTypeRegistry;
import com.strawberry.gaze.registry.GazeRiteRegistry;
import java.util.function.Function;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod(value="gaze")
public class GazeMod {
    public static final String MODID = "gaze";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"gaze");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"gaze");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"gaze");
    public static final DeferredItem<Item> ENCYCLOPEDIA_UNVEILED = ITEMS.register("encyclopedia_unveiled", () -> new EncyclopediaGazeItem((Item.Properties)GazeMod.GEAR_PROPERTIES().rarity(Rarity.EPIC).fireResistant()));
    public static final DeferredHolder<Item, Item> VEIL_DAGGER = GazeMod.register("veil_dagger", GazeMod.GEAR_PROPERTIES().rarity(Rarity.EPIC), p -> new VeilDaggerItem((Tier)MalumItemTiers.HARNESSED_CHAOS, 4.0f, (LodestoneItemProperties)p));
    public static final DeferredHolder<Item, Item> SPLINTERED_WORLD = GazeMod.register("splintered_world", GazeMod.GEAR_PROPERTIES().rarity(Rarity.EPIC), p -> new SplinteredWorld((Tier)MalumItemTiers.HARNESSED_CHAOS, 2.0f, (LodestoneItemProperties)p));
    public static final DeferredHolder<Item, Item> ASTRAL_SPLINTERED_WORLD = GazeMod.register("astral_splintered_world", GazeMod.GEAR_PROPERTIES().rarity(Rarity.EPIC), p -> new AstralSplinteredWorld((Tier)MalumItemTiers.HARNESSED_CHAOS, 8.0f, (LodestoneItemProperties)p));
    public static final DeferredHolder<Item, Item> ASTRAL_SPLINTERED_WORLDV1 = GazeMod.register("astral_splintered_worldv1", GazeMod.GEAR_PROPERTIES().rarity(Rarity.EPIC), p -> new AstralSplinteredWorld((Tier)MalumItemTiers.HARNESSED_CHAOS, 8.0f, (LodestoneItemProperties)p));
    public static final DeferredHolder<Item, Item> SOUL_RAPIER = GazeMod.register("soul_rapier", GazeMod.GEAR_PROPERTIES().rarity(Rarity.EPIC), p -> new SoulRapierItem((Tier)MalumItemTiers.HARNESSED_CHAOS, 1.0f, 1.0f, (LodestoneItemProperties)p));
    public static final DeferredHolder<Item, Item> SPIRIT_SABER = GazeMod.register("spirit_saber", GazeMod.GEAR_PROPERTIES().rarity(Rarity.EPIC), p -> new SpiritSaberItem((Tier)MalumItemTiers.HARNESSED_CHAOS, 2.0f, 10.0f, 3, (LodestoneItemProperties)p));
    public static final DeferredHolder<Item, Item> ADAPTIVE_WHEEL = GazeMod.register("adaptive_wheel", GazeMod.GEAR_PROPERTIES(), CurioAdaptiveResistanceWheel::new);
    public static final DeferredHolder<Item, Item> SLUGGISH_BROOCH = GazeMod.register("sluggish_brooch", GazeMod.GEAR_PROPERTIES(), CurioSluggishBrooch::new);
    public static final DeferredHolder<Item, Item> SEIDHR = GazeMod.register("seidhr", GazeMod.GEAR_PROPERTIES().rarity(Rarity.EPIC), p -> new SeidhrItem((Tier)MalumItemTiers.MALIGNANT_ALLOY, 4.0f, 60.0f, 5, (LodestoneItemProperties)p));
    public static final DeferredHolder<Item, Item> SWIFT_SPIRAL = GazeMod.register("swift_spiral", GazeMod.GEAR_PROPERTIES().rarity(Rarity.EPIC), p -> new SwiftSpiralItem((Tier)MalumItemTiers.MALIGNANT_ALLOY, 6.0f, 10.0f, 2, (LodestoneItemProperties)p));
    public static final DeferredHolder<Item, Item> CHARGE_NECKLACE = GazeMod.register("charge_necklace", GazeMod.GEAR_PROPERTIES(), CurioChargeNecklace::new);
    public static final DeferredHolder<Item, Item> MEDITATION_RING = GazeMod.register("meditation_ring", GazeMod.GEAR_PROPERTIES(), CurioMeditationRing::new);
    public static final DeferredHolder<Item, Item> COMPROMISE_RING = GazeMod.register("compromise_ring", GazeMod.GEAR_PROPERTIES(), CurioCompromiseRing::new);
    public static final DeferredHolder<Item, Item> SOUL_OF_THE_VEIL_DAGGER = GazeMod.register("soul_of_the_veil_dagger", MalumItems.HIDDEN_PROPERTIES(), TemporarilyDisabledItem::new);
    public static final DeferredHolder<Item, Item> RUNE_OF_BEYOND_THE_VEIL = GazeMod.register("rune_of_beyond_the_veil", GazeMod.GEAR_PROPERTIES(), RuneVeilItem::new);
    public static final DeferredHolder<Item, Item> RUNE_OF_OUT_OF_PHASE = GazeMod.register("rune_of_out_of_phase", GazeMod.GEAR_PROPERTIES(), RunePhaseItem::new);
    public static final DeferredHolder<Item, Item> RUNE_OF_BLIGHTED_PRESENCE = GazeMod.register("rune_of_blighted_presence", GazeMod.GEAR_PROPERTIES(), RuneBlightedItem::new);
    public static final DeferredHolder<Item, Item> RUNE_OF_TOUCH_OF_VOID = GazeMod.register("rune_of_touch_of_void", GazeMod.GEAR_PROPERTIES(), RuneVoidItem::new);
    public static final DeferredHolder<Item, Item> RUNE_OF_YMIR = GazeMod.register("rune_of_ymir", GazeMod.GEAR_PROPERTIES(), RuneYmirItem::new);
    public static final DeferredHolder<Item, Item> RUNE_OF_GYMIR = GazeMod.register("rune_of_gymir", GazeMod.GEAR_PROPERTIES(), RuneGymirItem::new);
    public static final DeferredHolder<Item, Item> RUNE_OF_FAFNIR = GazeMod.register("rune_of_fafnir", GazeMod.GEAR_PROPERTIES(), RuneFafnirItem::new);
    public static final DeferredHolder<Item, Item> RUNE_OF_EIR = GazeMod.register("rune_of_eir", GazeMod.GEAR_PROPERTIES(), RuneEirItem::new);
    public static final DeferredHolder<Item, GeasItem> GEAS = GazeMod.register("geas", MalumItems.HIDDEN_PROPERTIES(), GeasItem::new);
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"gaze");
    public static final DeferredHolder<MobEffect, BlightedEffect> BLIGHTED = EFFECTS.register("blighted", BlightedEffect::new);
    public static final DeferredHolder<MobEffect, CompromisedEffect> COMPROMISED = EFFECTS.register("compromised", CompromisedEffect::new);
    public static final DeferredHolder<MobEffect, WorldAnchorEffect> WORLD_ANCHOR = EFFECTS.register("world_anchor", WorldAnchorEffect::new);
    public static final DeferredHolder<MobEffect, JoyfulEffect> JOYFUL = EFFECTS.register("joyful", JoyfulEffect::new);
    public static final DeferredHolder<MobEffect, DrenchedEffect> DRENCHED = EFFECTS.register("drenched", DrenchedEffect::new);
    public static final DeferredRegister<ItemSubPredicate.Type<?>> ITEM_SUB_PREDICATES = DeferredRegister.create((ResourceKey)Registries.ITEM_SUB_PREDICATE_TYPE, (String)"gaze");
    public static final DeferredHolder<ItemSubPredicate.Type<?>, ItemSubPredicate.Type<SpiritSaberPredicate>> SPIRIT_SABER_PREDICATE = ITEM_SUB_PREDICATES.register("spirit_saber_predicate", () -> new ItemSubPredicate.Type(SpiritSaberPredicate.CODEC));

    public static LodestoneItemProperties GEAR_PROPERTIES() {
        return MalumItems.DEFAULT_PROPERTIES().stacksTo(1);
    }

    public static <T extends Item> DeferredHolder<Item, T> register(String name, LodestoneItemProperties properties, Function<LodestoneItemProperties, T> function) {
        return ITEMS.register(name, () -> (Item)function.apply(properties));
    }

    public GazeMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        GazeDataComponents.COMPONENTS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)new GazeEvents());
        NeoForge.EVENT_BUS.register((Object)new JoyfulEffectHandler());
        GazeEntityRegistry.ENTITY_TYPES.register(modEventBus);
        GazeGeasEffectTypeRegistry.GEAS_TYPES.register(modEventBus);
        EFFECTS.register(modEventBus);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        CreativeTabRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (!Config.disableGazeRites) {
            GazeRiteRegistry.register();
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeTabRegistry.GAZE_ITEMS.getKey()) {
            event.accept((ItemLike)VEIL_DAGGER.get());
            event.accept((ItemLike)SOUL_RAPIER.get());
            event.accept((ItemLike)SLUGGISH_BROOCH.get());
            event.accept((ItemLike)SEIDHR.get());
            event.accept((ItemLike)CHARGE_NECKLACE.get());
            event.accept((ItemLike)MEDITATION_RING.get());
            event.accept((ItemLike)COMPROMISE_RING.get());
            event.accept((ItemLike)RUNE_OF_BEYOND_THE_VEIL.get());
            event.accept((ItemLike)RUNE_OF_OUT_OF_PHASE.get());
            event.accept((ItemLike)RUNE_OF_BLIGHTED_PRESENCE.get());
            event.accept((ItemLike)RUNE_OF_TOUCH_OF_VOID.get());
            event.accept((ItemLike)RUNE_OF_YMIR.get());
            event.accept((ItemLike)RUNE_OF_GYMIR.get());
            event.accept((ItemLike)RUNE_OF_EIR.get());
            event.accept((ItemLike)RUNE_OF_FAFNIR.get());
            event.accept((ItemLike)ENCYCLOPEDIA_UNVEILED.get());
            event.accept((ItemLike)SPLINTERED_WORLD.get());
            event.accept((ItemLike)SPIRIT_SABER.get());
            event.accept((ItemLike)SWIFT_SPIRAL.get());
            event.accept((ItemLike)ADAPTIVE_WHEEL.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public static ResourceLocation gazePath(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @EventBusSubscriber(modid="gaze", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            CuriosRendererRegistry.register((Item)((Item)ADAPTIVE_WHEEL.get()), WheelCurioRenderer::new);
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)SPIRIT_SABER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)GazeMod.MODID, (String)"active_spirit"), (stack, level, player, seed) -> {
                String type = (String)stack.get((DataComponentType)GazeDataComponents.ACTIVE_SPIRIT.get());
                if (type == null) {
                    return 0.0f;
                }
                return switch (type) {
                    case "malum:sacred_spirit" -> 1.0f;
                    case "malum:wicked_spirit" -> 2.0f;
                    case "malum:arcane_spirit" -> 3.0f;
                    case "malum:eldritch_spirit" -> 4.0f;
                    case "malum:aerial_spirit" -> 5.0f;
                    case "malum:aqueous_spirit" -> 6.0f;
                    case "malum:earthen_spirit" -> 7.0f;
                    case "malum:infernal_spirit" -> 8.0f;
                    case "malum:umbral_spirit" -> 9.0f;
                    default -> 0.0f;
                };
            }));
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
        }
    }
}

