/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.loader.translator;

import java.io.IOException;
import java.util.HashMap;
import net.creeperhost.levelio.data.Block;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.data.Entity;
import net.creeperhost.levelio.data.Section;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.IListTag;
import net.creeperhost.levelio.loader.translator.ChunkTranslator;
import net.creeperhost.levelio.loader.translator.PaletteDecoders;

public class Translator113Plus
extends ChunkTranslator {
    public static final ChunkTranslator INSTANCE = new Translator113Plus();

    @Override
    public void readChunkData(Chunk chunk) throws IOException {
        IListTag entities;
        IListTag tiles;
        ICompoundTag tag = chunk.getChunkTag();
        tag = tag.getCompound("Level");
        chunk.inhabitedTime = tag.getLong("InhabitedTime");
        IListTag sections = tag.getList("Sections", 10);
        for (int i = 0; i < sections.size(); ++i) {
            ICompoundTag sectionTag = sections.getCompound(i);
            byte sectionY = sectionTag.getByte("Y");
            Section section = new Section(sectionY, chunk);
            section.setLoader(e -> this.populateSection((Section)e, sectionTag));
            chunk.addSection(section);
        }
        IListTag iListTag = tiles = tag.contains("TileEntities", 10) ? tag.getList("TileEntities", 10) : null;
        if (tiles != null) {
            for (int i = 0; i < tiles.size(); ++i) {
                ICompoundTag tileTag = tiles.getCompound(i);
                chunk.tileData.put(BlockPos.fromTileTag(tileTag), tileTag);
            }
        }
        IListTag iListTag2 = entities = tag.contains("Entities", 10) ? tag.getList("Entities", 10) : null;
        if (entities != null) {
            for (int i = 0; i < entities.size(); ++i) {
                ICompoundTag entityTag = entities.getCompound(i);
                chunk.entities.add(new Entity(entityTag));
            }
        }
    }

    private void populateSection(Section section, ICompoundTag sectionTag) {
        if (!sectionTag.contains("Palette") || !sectionTag.contains("BlockStates")) {
            return;
        }
        long[] blockStates = sectionTag.getLongArray("BlockStates");
        IListTag palette = sectionTag.getList("Palette", 10);
        HashMap<Integer, ICompoundTag> stateMap = new HashMap<Integer, ICompoundTag>();
        for (int i = 0; i < palette.size(); ++i) {
            stateMap.put(i, palette.getCompound(i));
        }
        Chunk chunk = section.getChunk();
        int[] blocksParsed = chunk.chunkDataVersion < 2566 ? PaletteDecoders.decode113(blockStates) : PaletteDecoders.decode116(blockStates, palette.size());
        for (int index = 0; index < 4096; ++index) {
            int paletteIndex = blocksParsed[index];
            if (paletteIndex >= palette.size()) {
                LOGGER.warn("Block in chunk {} int world {} was not in block palette! This may indicate chunk corruption.", (Object)chunk.pos, (Object)chunk.region.levelInfo.dimFolder.getFileName());
                continue;
            }
            ICompoundTag data = (ICompoundTag)stateMap.get(paletteIndex);
            section.set(index, new Block(data));
        }
    }

    @Override
    public void writeChunkData(Chunk chunk) throws IOException {
    }
}

