/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.net.covers1624.quack.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class LowerCaseEnumAdapter<E extends Enum<E>>
extends TypeAdapter<E> {
    private final Map<String, E> table;

    public LowerCaseEnumAdapter(Class<? super E> clazz) {
        HashMap<String, E> table = new HashMap<String, E>();
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            table.put(e.name().toLowerCase(Locale.ROOT), e);
        }
        this.table = table;
    }

    public void write(JsonWriter out, @Nullable E value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.value(((Enum)value).name().toLowerCase(Locale.ROOT));
        }
    }

    @Nullable
    public E read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String name = in.nextString();
        if (name == null) {
            return null;
        }
        return (E)((Enum)this.table.get(name.toLowerCase(Locale.ROOT)));
    }
}

