/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.creeperhost.ftbbackups.BackupHandler;
import net.creeperhost.ftbbackups.commands.BackupCommand;
import net.creeperhost.ftbbackups.config.Config;
import net.creeperhost.ftbbackups.repack.org.quartz.CronExpression;
import net.creeperhost.ftbbackups.repack.org.quartz.CronScheduleBuilder;
import net.creeperhost.ftbbackups.repack.org.quartz.CronTrigger;
import net.creeperhost.ftbbackups.repack.org.quartz.Job;
import net.creeperhost.ftbbackups.repack.org.quartz.JobBuilder;
import net.creeperhost.ftbbackups.repack.org.quartz.JobDetail;
import net.creeperhost.ftbbackups.repack.org.quartz.JobExecutionContext;
import net.creeperhost.ftbbackups.repack.org.quartz.Scheduler;
import net.creeperhost.ftbbackups.repack.org.quartz.TriggerBuilder;
import net.creeperhost.ftbbackups.repack.org.quartz.impl.StdSchedulerFactory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBBackups {
    public static final String MOD_ID = "ftbbackups2";
    public static Logger LOGGER = LogManager.getLogger();
    public static Path configFile = Platform.getConfigFolder().resolve("ftbbackups2.json");
    public static final ScheduledExecutorService configWatcherExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setUncaughtExceptionHandler((t, e) -> LOGGER.error("An error occurred running watcher task", e)).setNameFormat("FTB Backups Config Watcher %d").build());
    public static final ScheduledExecutorService backupCleanerExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setUncaughtExceptionHandler((t, e) -> LOGGER.error("An error occurred running cleaner task", e)).setNameFormat("FTB Backups scheduled executor %d").build());
    public static final ExecutorService backupExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setUncaughtExceptionHandler((t, e) -> LOGGER.error("An error occurred running backup task", e)).setNameFormat("FTB Backups backup thread %d").build());
    public static MinecraftServer minecraftServer;
    public static Scheduler scheduler;
    public static boolean isShutdown;

    public static void init() {
        Config.init(configFile.toFile());
        if (!Config.cached().enabled) {
            return;
        }
        CommandRegistrationEvent.EVENT.register((dispatcher, registry, selection) -> dispatcher.register(BackupCommand.register()));
        LifecycleEvent.SERVER_STARTED.register(FTBBackups::serverStartedEvent);
        LifecycleEvent.SERVER_STOPPING.register(instance -> FTBBackups.onShutdown());
        TickEvent.SERVER_PRE.register(FTBBackups::onServerTickPre);
        backupCleanerExecutorService.scheduleAtFixedRate(BackupHandler::clean, 0L, 30L, TimeUnit.SECONDS);
        if (!CronExpression.isValidExpression(Config.cached().backup_cron)) {
            LOGGER.error("backup_cron is invalid, restoring default value");
            Config.cached().backup_cron = "0 */30 * * * ?";
            Config.saveConfig();
        }
        try {
            JobDetail jobDetail = JobBuilder.newJob(BackupJob.class).withIdentity(MOD_ID).build();
            Properties properties = new Properties();
            properties.put("net.creeperhost.ftbbackups.repack.org.quartz.scheduler.instanceName", MOD_ID);
            properties.put("net.creeperhost.ftbbackups.repack.org.quartz.threadPool.threadCount", "1");
            properties.put("net.creeperhost.ftbbackups.repack.org.quartz.threadPool.makeThreadsDaemons", "true");
            properties.put("net.creeperhost.ftbbackups.repack.org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(properties);
            scheduler = schedulerFactory.getScheduler();
            CronTrigger trigger = TriggerBuilder.newTrigger().withIdentity(MOD_ID).withSchedule(CronScheduleBuilder.cronSchedule(Config.cached().backup_cron)).build();
            scheduler.start();
            scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while, starting backup scheduler", (Throwable)e);
        }
    }

    private static void onServerTickPre(MinecraftServer server) {
        if (server == null) {
            return;
        }
        PlayerList list = server.getPlayerList();
        if (list == null) {
            return;
        }
        BackupHandler.isDirty |= list.getPlayerCount() > 0;
    }

    private static void serverStartedEvent(MinecraftServer minecraftServer) {
        FTBBackups.minecraftServer = minecraftServer;
        BackupHandler.init(minecraftServer);
        isShutdown = false;
    }

    public static void onShutdown() {
        if (isShutdown) {
            return;
        }
        try {
            int shutdownCount = 0;
            isShutdown = true;
            while (BackupHandler.isRunning() && shutdownCount <= 120) {
                try {
                    if (shutdownCount % 10 == 0) {
                        LOGGER.info("Backup in progress, Waiting for it to finish before shutting down.");
                    }
                    Thread.sleep(1000L);
                    ++shutdownCount;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (Config.watcher.get() != null) {
                Config.watcher.get().close();
            }
            BackupHandler.backupRunning.set(false);
            LOGGER.info("Shutdown Complete");
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during shutdown process", (Throwable)e);
        }
    }

    static {
        isShutdown = false;
    }

    public static class BackupJob
    implements Job {
        @Override
        public void execute(JobExecutionContext context) {
            if (minecraftServer != null && !isShutdown) {
                LOGGER.info("Attempting to create an automatic backup");
                BackupHandler.createBackup(minecraftServer);
            }
        }
    }
}

