/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import website.eccentric.tome.TomeUtils;

public record RevertPayload() implements CustomPacketPayload
{
    public static final RevertPayload INSTANCE = new RevertPayload();
    public static final CustomPacketPayload.Type<RevertPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eccentrictome", (String)"revert_payload"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RevertPayload> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void revert(RevertPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            PacketFlow direction = context.flow();
            InteractionHand hand = TomeUtils.inHand(player);
            if (hand != null) {
                ItemStack stack = player.getItemInHand(hand);
                ItemStack tome = TomeUtils.revert(stack);
                player.setItemInHand(hand, tome);
                if (direction.getReceptionSide().isClient()) {
                    Minecraft.getInstance().gameRenderer.itemInHandRenderer.itemUsed(hand);
                }
            }
        });
    }
}

