/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.PacketDistributor;
import website.eccentric.tome.TomeUtils;
import website.eccentric.tome.network.ConvertPayload;

public class TomeScreen
extends Screen {
    private static final int LEFT_CLICK = 0;
    private final ItemStack tome;
    private ItemStack book;

    public TomeScreen(ItemStack tome) {
        super((Component)Component.empty());
        this.tome = tome;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (button != 0 || this.book == null) {
            return super.mouseClicked(x, y, button);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ConvertPayload(this.book), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Minecraft minecraft = this.minecraft;
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (minecraft != null && minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float ticks) {
        Minecraft minecraft = this.minecraft;
        if (minecraft == null) {
            return;
        }
        super.render(gui, mouseX, mouseY, ticks);
        List books = TomeUtils.getModsBooks(this.tome).modList().values().stream().flatMap(Collection::stream).toList();
        Window window = minecraft.getWindow();
        int booksPerRow = 6;
        int rows = books.size() / booksPerRow + 1;
        int iconSize = 20;
        int startX = window.getGuiScaledWidth() / 2 - booksPerRow * iconSize / 2;
        int startY = window.getGuiScaledHeight() / 2 - rows * iconSize + 45;
        int padding = 4;
        gui.fill(startX - padding, startY - padding, startX + iconSize * booksPerRow + padding, startY + iconSize * rows + padding, 0x22000000);
        this.book = null;
        int index = 0;
        for (ItemStack book : books) {
            if (book.is(Items.AIR)) continue;
            int stackX = startX + index % booksPerRow * iconSize;
            int stackY = startY + index / booksPerRow * iconSize;
            if (mouseX > stackX && mouseY > stackY && mouseX <= stackX + 16 && mouseY <= stackY + 16) {
                this.book = book;
            }
            gui.renderItem(book, stackX, stackY);
            gui.renderItemDecorations(this.font, book, mouseX, mouseY);
            ++index;
        }
        if (this.book != null) {
            gui.renderComponentTooltip(this.font, TomeScreen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)this.book), mouseX, mouseY);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }
}

