/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import website.eccentric.tome.EccentricConfig;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.TomeItem;
import website.eccentric.tome.TomeUtils;

public class AttachmentRecipe
extends CustomRecipe {
    public AttachmentRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput crafting, Level level) {
        EccentricTome.LOGGER.debug("Matching");
        boolean foundTome = false;
        boolean foundTarget = false;
        for (int i = 0; i < crafting.size(); ++i) {
            ItemStack stack = crafting.getItem(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                return false;
            }
            if (item instanceof TomeItem) {
                if (foundTome) {
                    return false;
                }
                foundTome = true;
                continue;
            }
            if (this.isTarget(stack)) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            return false;
        }
        return foundTome && foundTarget;
    }

    public ItemStack assemble(CraftingInput crafting, HolderLookup.Provider access) {
        ItemStack tome = ItemStack.EMPTY;
        ItemStack target = ItemStack.EMPTY;
        for (int i = 0; i < crafting.size(); ++i) {
            ItemStack stack = crafting.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof TomeItem) {
                tome = stack;
                continue;
            }
            target = stack;
        }
        tome = tome.copy();
        return TomeUtils.attach(tome, target);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public boolean isTarget(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        String locationString = location.toString();
        String locationDamage = locationString + ":" + stack.getDamageValue();
        List items = (List)EccentricConfig.ITEMS.get();
        return location.getNamespace().equals("patchouli") || location.getNamespace().equals("modonomicon") || items.contains(locationString) || items.contains(locationDamage);
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput crafting) {
        return NonNullList.withSize((int)crafting.size(), (Object)ItemStack.EMPTY);
    }

    public RecipeSerializer<?> getSerializer() {
        return EccentricTome.ATTACHMENT.get();
    }
}

