/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.InventoryCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class RemoveFromInventorySlotCommand {
    private static final List<String> invTypes = new ArrayList<String>(Arrays.asList("inventory", "armor", "offhand"));
    private static SuggestionProvider<CommandSourceStack> invtype;

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        if (CrashUtils.curiosLoaded && CuriosApi.getSlotHelper() != null) {
            invTypes.addAll(CuriosApi.getSlotHelper().getSlotTypeIds());
        }
        invtype = (ctx, builder) -> SharedSuggestionProvider.suggest(invTypes.stream(), (SuggestionsBuilder)builder);
        return Commands.literal((String)"remove").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).then(Commands.argument((String)"slotType", (ArgumentType)StringArgumentType.string()).suggests(invtype).then(Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RemoveFromInventorySlotCommand.removeFromSlot((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"slotType"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot")))))).then(Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RemoveFromInventorySlotCommand.removeFromSlot((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), "inventory", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot")))));
    }

    private static int removeFromSlot(CommandContext<CommandSourceStack> context, String name, String inventoryType, int slot) {
        AtomicReference<MutableComponent> text = new AtomicReference<MutableComponent>(CommandUtils.CreateTextComponent(""));
        AtomicBoolean success = new AtomicBoolean(false);
        WorldUtils.applyToPlayer(name, ((CommandSourceStack)context.getSource()).getServer(), player -> {
            switch (inventoryType) {
                case "inventory": {
                    if (((ItemStack)player.getInventory().items.get(slot)).isEmpty()) {
                        success.set(false);
                        return;
                    }
                    text.set(((ItemStack)player.getInventory().items.get(slot)).getDisplayName().copy());
                    player.getInventory().items.set(slot, (Object)ItemStack.EMPTY);
                    break;
                }
                case "armor": {
                    if (((ItemStack)player.getInventory().armor.get(slot)).isEmpty()) {
                        success.set(false);
                        return;
                    }
                    text.set(((ItemStack)player.getInventory().armor.get(slot)).getDisplayName().copy());
                    player.getInventory().armor.set(slot, (Object)ItemStack.EMPTY);
                    break;
                }
                case "offhand": {
                    if (((ItemStack)player.getInventory().offhand.get(slot)).isEmpty()) {
                        success.set(false);
                        return;
                    }
                    text.set(((ItemStack)player.getInventory().offhand.get(slot)).getDisplayName().copy());
                    player.getInventory().offhand.set(slot, (Object)ItemStack.EMPTY);
                    break;
                }
                default: {
                    if (!CrashUtils.curiosLoaded || !CuriosApi.getSlotHelper().getSlotTypeIds().contains(inventoryType)) break;
                    ICuriosItemHandler handler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).orElse(null);
                    if (((ICurioStacksHandler)handler.getStacksHandler(inventoryType).get()).getStacks().getStackInSlot(slot).isEmpty()) {
                        success.set(false);
                        return;
                    }
                    text.set(((ICurioStacksHandler)handler.getStacksHandler(inventoryType).get()).getStacks().getStackInSlot(slot).getDisplayName().copy());
                    ((ICurioStacksHandler)handler.getStacksHandler(inventoryType).get()).getStacks().setStackInSlot(slot, ItemStack.EMPTY);
                }
            }
            success.set(true);
        });
        if (success.get()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ((MutableComponent)text.get()).append((Component)CommandUtils.CreateTextComponent(" has been deleted from " + name + "'s InventorySlot")), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Failed to delete item from slot" + slot + ", slot is empty?"), true);
        }
        return 1;
    }
}

