/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.Screens.CUScreen;
import com.darkere.crashutils.Screens.PlayerInvContainer;
import com.darkere.crashutils.Screens.PlayerInvScreen;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

public class ClientEvents {
    public static final KeyMapping OPENSCREEN = new KeyMapping("crashutils.openscreen", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 85, "crashutils.keycategory");
    public static final KeyMapping COPYCLASS = new KeyMapping("crashutils.copycontainer", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.UNKNOWN, "crashutils.keycategory");
    public static final KeyMapping TOGGLEINDEXES = new KeyMapping("crashutils.slottooltips", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "crashutils.keycategory");
    private static boolean renderslotnumbers;

    public static void registerKeybindings(RegisterKeyMappingsEvent event) {
        event.register(OPENSCREEN);
        event.register(COPYCLASS);
        event.register(TOGGLEINDEXES);
    }

    @SubscribeEvent
    public void drawEvent(ScreenEvent.Render.Pre event) {
        if (!renderslotnumbers) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (screen2.getSlotUnderMouse() == null) {
                return;
            }
            event.getGuiGraphics().renderTooltip(Minecraft.getInstance().font, (Component)CommandUtils.CreateTextComponent("Index: " + screen2.getSlotUnderMouse().getSlotIndex()), event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public void GUIKeyEvent(ScreenEvent.KeyPressed.Post event) {
        if (Minecraft.getInstance().player == null || !(event.getScreen() instanceof AbstractContainerScreen)) {
            return;
        }
        if (COPYCLASS.consumeClick()) {
            String toCopy = Minecraft.getInstance().player.containerMenu.getClass().getName();
            Minecraft.getInstance().keyboardHandler.setClipboard(toCopy);
        }
        if (TOGGLEINDEXES.consumeClick()) {
            renderslotnumbers = !renderslotnumbers;
        }
    }

    @SubscribeEvent
    public void keyEvent(InputEvent.Key event) {
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().level == null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        if (OPENSCREEN.consumeClick()) {
            ResourceKey worldKey = Minecraft.getInstance().player.getCommandSenderWorld().dimension();
            if (Minecraft.getInstance().player.hasPermissions(2)) {
                Vec3 pos = Minecraft.getInstance().player.position();
                Vec3i posi = new Vec3i((int)pos.x, (int)pos.y, (int)pos.z);
                Minecraft.getInstance().setScreen((Screen)CUScreen.openCUScreen((ResourceKey<Level>)worldKey, new BlockPos(posi)));
            } else if (!Minecraft.getInstance().hasSingleplayerServer()) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)CommandUtils.CreateTextComponent("You need to be OP to use the Crash Utils GUI"), false);
            } else {
                Minecraft.getInstance().gui.setOverlayMessage((Component)CommandUtils.CreateTextComponent("Cheats need to be enabled to use the Crash Utils GUI"), false);
            }
        }
    }

    public static void openContainerAndScreen(int id, String playerName, Map<String, Integer> curios) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        PlayerInvContainer c = new PlayerInvContainer((Player)player, null, id, playerName, curios, curios.values().stream().mapToInt(x -> x).sum());
        player.containerMenu = c;
        Minecraft.getInstance().setScreen((Screen)new PlayerInvScreen(c, player.getInventory(), (Component)CommandUtils.CreateTextComponent("cuinventoryscreen")));
    }
}

