/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.recipes;

import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipe;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipes;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class SpawnerRecipeBuilder {
    private final ResourceLocation id;
    private final ResourceLocation entity;
    private int power = 0;
    private SpawnerRecipes.MobSpawnAmount item1;
    private SpawnerRecipes.MobSpawnAmount item2;
    private SpawnerRecipes.MobSpawnAmount item3;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.advancement();
    private ShapedRecipeBuilder builder;

    private SpawnerRecipeBuilder(EntityType entity) {
        this.id = ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)(Tools.getId((EntityType)entity).getNamespace() + "_" + Tools.getId((EntityType)entity).getPath()));
        this.entity = Tools.getId((EntityType)entity);
        this.builder = new ShapedRecipeBuilder(RecipeCategory.MISC, (ItemLike)Items.AIR, 0);
    }

    public static SpawnerRecipeBuilder create(EntityType entity) {
        return new SpawnerRecipeBuilder(entity);
    }

    public SpawnerRecipeBuilder power(int power) {
        this.power = power;
        return this;
    }

    public SpawnerRecipeBuilder item1(Ingredient ingredient, float amount) {
        this.item1 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        return this;
    }

    public SpawnerRecipeBuilder item2(Ingredient ingredient, float amount) {
        this.item2 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        return this;
    }

    public SpawnerRecipeBuilder item3(Ingredient ingredient, float amount) {
        this.item3 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        return this;
    }

    public void build(RecipeOutput consumerIn) {
        consumerIn.accept(this.id, (Recipe)new SpawnerRecipe(this.id, this.item1, this.item2, this.item3, this.power, this.entity), null);
    }
}

