/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketModuleUpdate(BlockPos pos, Integer slotIndex, ItemStack module) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"moduleupdate");
    public static final CustomPacketPayload.Type<PacketModuleUpdate> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketModuleUpdate> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketModuleUpdate::pos, (StreamCodec)ByteBufCodecs.INT, PacketModuleUpdate::slotIndex, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, PacketModuleUpdate::module, PacketModuleUpdate::new);

    public static PacketModuleUpdate create(BlockPos blockPos, int slotIndex, ItemStack module) {
        return new PacketModuleUpdate(blockPos, slotIndex, module);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            Level world = player.getCommandSenderWorld();
            if (world.hasChunkAt(this.pos)) {
                double dist = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue() + 3.0;
                if (player.distanceToSqr((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) >= dist * dist) {
                    return;
                }
                BlockEntity patt0$temp = world.getBlockEntity(this.pos);
                if (patt0$temp instanceof ScreenTileEntity) {
                    ScreenTileEntity screen = (ScreenTileEntity)patt0$temp;
                    screen.updateModuleData(this.slotIndex, this.module);
                }
            }
        });
    }
}

