/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ClientScreenModuleHelper;
import mcjty.rftoolsutility.modules.screen.network.PacketGetScreenData;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ScreenRenderer
implements BlockEntityRenderer<ScreenTileEntity> {
    private static final ClientScreenModuleHelper clientScreenModuleHelper = new ClientScreenModuleHelper();

    public ScreenRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull ScreenTileEntity tileEntity, float v, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int packedLightIn, int packedOverlayIn) {
        ScreenRenderer.renderInternal(tileEntity, matrixStack, buffer, packedLightIn, packedOverlayIn);
    }

    public static void renderInternal(ScreenTileEntity tileEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn, int packedOverlayIn) {
        float xRotation = 0.0f;
        float yRotation = 0.0f;
        Direction facing = Direction.SOUTH;
        Direction horizontalFacing = Direction.SOUTH;
        if (!tileEntity.isDummy()) {
            BlockState state = Minecraft.getInstance().level.getBlockState(tileEntity.getBlockPos());
            if (state.getBlock() instanceof ScreenBlock) {
                facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                horizontalFacing = (Direction)state.getValue((Property)ScreenBlock.HORIZ_FACING);
            } else {
                return;
            }
        }
        matrixStack.pushPose();
        switch (horizontalFacing) {
            case NORTH: {
                yRotation = -180.0f;
                break;
            }
            case WEST: {
                yRotation = -90.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
            }
        }
        switch (facing) {
            case DOWN: {
                xRotation = 90.0f;
                break;
            }
            case UP: {
                xRotation = -90.0f;
            }
        }
        matrixStack.translate(0.5f, 0.5f, 0.5f);
        RenderHelper.rotateYP((PoseStack)matrixStack, (float)yRotation);
        RenderHelper.rotateXP((PoseStack)matrixStack, (float)xRotation);
        matrixStack.translate(0.0f, 0.0f, -0.4375f);
        if (tileEntity.isDummy()) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            GuiGraphics graphics = new GuiGraphics(Minecraft.getInstance(), Minecraft.getInstance().renderBuffers().bufferSource());
            graphics.pose().last().pose().set((Matrix4fc)matrixStack.last().pose());
            graphics.pose().last().normal().set((Matrix3fc)matrixStack.last().normal());
            graphics.fill(98, 28, 252, 182, -2236963);
            graphics.fill(100, 30, 250, 180, -13421773);
            matrixStack.translate(100.0f, 30.0f, 0.0f);
        } else if (!tileEntity.isTransparent()) {
            ScreenRenderer.renderScreenBoard(matrixStack, buffer, tileEntity.getSize(), tileEntity.getColor(), packedLightIn, packedOverlayIn);
        }
        if (tileEntity.isRenderable()) {
            Font fontrenderer = Minecraft.getInstance().font;
            Map<Integer, IModuleData> screenData = ScreenRenderer.updateScreenData(tileEntity);
            List<Pair<ItemStack, IClientScreenModule<?>>> modules = tileEntity.getClientScreenModules();
            if (tileEntity.isShowHelp()) {
                modules = ScreenTileEntity.getHelpingScreenModules();
            }
            GuiGraphics graphics = new GuiGraphics(Minecraft.getInstance(), Minecraft.getInstance().renderBuffers().bufferSource());
            graphics.pose().last().pose().set((Matrix4fc)matrixStack.last().pose());
            graphics.pose().last().normal().set((Matrix3fc)matrixStack.last().normal());
            ScreenRenderer.renderModules(graphics, buffer, fontrenderer, tileEntity, modules, screenData, tileEntity.isDummy() ? 0 : tileEntity.getSize());
        }
        matrixStack.popPose();
    }

    private static Map<Integer, IModuleData> updateScreenData(ScreenTileEntity screenTileEntity) {
        GlobalPos key;
        Map<Integer, Object> screenData;
        long millis = System.currentTimeMillis();
        if (millis - screenTileEntity.lastTime > (long)((Integer)ScreenConfiguration.SCREEN_REFRESH_TIMING.get()).intValue() && screenTileEntity.isNeedsServerData()) {
            screenTileEntity.lastTime = millis;
            GlobalPos pos = GlobalPos.of(screenTileEntity.getDimension(), (BlockPos)screenTileEntity.getBlockPos());
            RFToolsUtilityMessages.sendToServer(PacketGetScreenData.create("rftoolsutility", pos, millis));
        }
        if ((screenData = ScreenTileEntity.screenData.get(key = GlobalPos.of(screenTileEntity.getDimension(), (BlockPos)screenTileEntity.getBlockPos()))) == null) {
            screenData = Collections.emptyMap();
        }
        return screenData;
    }

    private static void renderModules(GuiGraphics graphics, MultiBufferSource buffer, Font fontrenderer, ScreenTileEntity tileEntity, List<Pair<ItemStack, IClientScreenModule<?>>> modules, Map<Integer, IModuleData> screenData, int size) {
        PoseStack stack;
        float factor = (float)size + 1.0f;
        int currenty = 7;
        int moduleIndex = 0;
        float f = 0.0075f;
        float minf3 = -1.0f;
        if (tileEntity.isDummy()) {
            stack = new PoseStack();
            stack.translate(100.0f, 30.0f, 0.0f);
            f = 1.0f;
            minf3 = 1.0f;
        } else {
            stack = graphics.pose();
        }
        BlockPos pos = tileEntity.getBlockPos();
        HitResult mouseOver = Minecraft.getInstance().hitResult;
        Pair<ItemStack, IClientScreenModule<?>> hitModule = null;
        ScreenTileEntity.ModuleRaytraceResult hit = null;
        if (!tileEntity.isDummy()) {
            Direction horizontalFacing;
            double zz;
            double yy;
            double xx;
            Direction sideHit;
            BlockState blockState = tileEntity.getLevel().getBlockState(pos);
            Block block = blockState.getBlock();
            if (block != ScreenModule.SCREEN.block().get() && block != ScreenModule.CREATIVE_SCREEN.block().get() && block != ScreenModule.SCREEN_HIT.block().get()) {
                return;
            }
            if (mouseOver instanceof BlockHitResult && (sideHit = ((BlockHitResult)mouseOver).getDirection()) == blockState.getValue((Property)BlockStateProperties.FACING) && (hit = tileEntity.getHitModule(xx = mouseOver.getLocation().x - (double)pos.getX(), yy = mouseOver.getLocation().y - (double)pos.getY(), zz = mouseOver.getLocation().z - (double)pos.getZ(), sideHit, horizontalFacing = (Direction)blockState.getValue((Property)ScreenBlock.HORIZ_FACING), tileEntity.isDummy() ? 1 : tileEntity.getSize())) != null) {
                hitModule = modules.get(hit.moduleIndex());
            }
        }
        for (Pair<ItemStack, IClientScreenModule<?>> pair : modules) {
            int height;
            if (pair == null) continue;
            IClientScreenModule module = (IClientScreenModule)pair.getRight();
            if (module != null && currenty + (height = module.getHeight((ItemStack)pair.getLeft())) <= 124) {
                stack.pushPose();
                switch (module.getTransformMode((ItemStack)pair.getLeft())) {
                    case TEXT: {
                        stack.translate(-0.5f, 0.5f, 0.03f);
                        stack.scale(f * factor, minf3 * f * factor, f);
                        break;
                    }
                    case TEXTLARGE: {
                        stack.translate(-0.5f, 0.5f, 0.03f);
                        stack.scale(f * 2.0f * factor, minf3 * f * 2.0f * factor, f * 2.0f);
                        break;
                    }
                    case ITEM: {
                        stack.translate(0.0f, 0.0f, -0.04f);
                        if (!tileEntity.isDummy()) break;
                        stack.translate(65.0f, 70.0f, 0.0f);
                        stack.scale(133.33334f, -133.33334f, 10000.0f);
                    }
                }
                IModuleData data = screenData.get(moduleIndex);
                try {
                    int hitx = -1;
                    int hity = -1;
                    if (module == hitModule) {
                        hitx = hit.x();
                        hity = hit.y() - hit.currenty();
                    }
                    boolean truetype = false;
                    switch (tileEntity.getTrueTypeMode()) {
                        case -1: {
                            break;
                        }
                        case 1: {
                            truetype = (Boolean)ScreenConfiguration.forceNoTruetype.get() == false;
                            break;
                        }
                        case 0: {
                            if (((Boolean)ScreenConfiguration.forceNoTruetype.get()).booleanValue()) break;
                            truetype = (Boolean)ScreenConfiguration.useTruetype.get();
                        }
                    }
                    ModuleRenderInfo renderInfo = new ModuleRenderInfo(factor, pos, hitx, hity, truetype, tileEntity.isBright() || tileEntity.isDummy(), ScreenConfiguration.getTrueTypeFont(), (ItemStack)pair.getLeft());
                    module.render(graphics, buffer, (IModuleRenderHelper)clientScreenModuleHelper, fontrenderer, currenty, data, renderInfo);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                currenty += height;
                stack.popPose();
            }
            ++moduleIndex;
        }
    }

    private static void renderScreenBoard(PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int size, int color, int packedLightIn, int packedOverlayIn) {
        matrixStack.pushPose();
        matrixStack.scale(1.0f, -1.0f, -1.0f);
        VertexConsumer builder = buffer.getBuffer(CustomRenderTypes.QUADS_NOTEXTURE);
        float dim = switch (size) {
            case 2 -> 2.46f;
            case 1 -> 1.46f;
            default -> 0.46f;
        };
        float fr = 0.5f;
        float fg = 0.5f;
        float fb = 0.5f;
        float zback = 0.05f;
        float zfront = 0.0f;
        float ss = 0.5f;
        RenderHelper.drawBox((PoseStack)matrixStack, (VertexConsumer)builder, (float)(-ss), (float)(ss + (float)size), (float)(-ss), (float)(ss + (float)size), (float)zback, (float)zfront, (float)fr, (float)fg, (float)fb, (int)packedLightIn);
        RenderHelper.drawQuadGui((PoseStack)matrixStack, (VertexConsumer)builder, (float)-0.46f, (float)dim, (float)-0.46f, (float)dim, (float)-0.01f, (int)(0xFF000000 | color), (int)packedLightIn);
        matrixStack.popPose();
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ScreenModule.SCREEN.be().get()), ScreenRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ScreenModule.CREATIVE_SCREEN.be().get()), ScreenRenderer::new);
    }

    public AABB getRenderBoundingBox(ScreenTileEntity be) {
        int xCoord = be.getBlockPos().getX();
        int yCoord = be.getBlockPos().getY();
        int zCoord = be.getBlockPos().getZ();
        int size = be.getSize();
        return new AABB((double)(xCoord - size - 1), (double)(yCoord - size - 1), (double)(zCoord - size - 1), (double)(xCoord + size + 1), (double)(yCoord + size + 1), (double)(zCoord + size + 1));
    }
}

