/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.items;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.rftoolsbase.modules.tablet.items.TabletItem;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationItem;
import mcjty.rftoolsutility.modules.logic.network.PacketSendRedstoneData;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneInformationContainer
extends GenericContainer {
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(0));
    private final Player player;
    private final Level world;
    private Map<Integer, Pair<String, Integer>> values = null;

    public void sendData(Map<Integer, Pair<String, Integer>> channelData) {
        this.values = channelData;
    }

    public Map<Integer, Pair<String, Integer>> getChannelData() {
        return this.values;
    }

    public static ItemStack getRedstoneInformationItem(Player player) {
        ItemStack tabletItem = player.getItemInHand(TabletItem.getHand((Player)player));
        if (tabletItem.getItem() instanceof RedstoneInformationItem) {
            return tabletItem;
        }
        return TabletItem.getContainingItem((ItemStack)tabletItem, (int)TabletItem.getCurrentSlot((ItemStack)tabletItem));
    }

    public RedstoneInformationContainer(int id, BlockPos pos, Player player) {
        super(LogicBlockModule.CONTAINER_REDSTONE_INFORMATION.get(), id, (ContainerFactory)CONTAINER_FACTORY.get(), pos, null, player);
        this.player = player;
        this.world = player.getCommandSenderWorld();
    }

    public void setupInventories(IItemHandler itemHandler, Inventory inventory) {
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        boolean dirty = false;
        RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(this.world);
        ItemStack infoItem = RedstoneInformationContainer.getRedstoneInformationItem(this.player);
        Set<Integer> channels = RedstoneInformationItem.getChannels(infoItem);
        if (this.values == null || this.values.size() != channels.size()) {
            this.values = new HashMap<Integer, Pair<String, Integer>>();
            for (Integer channel : channels) {
                c = redstoneChannels.getChannel(channel);
                if (c == null) continue;
                this.values.put(channel, (Pair<String, Integer>)Pair.of((Object)c.getName(), (Object)c.getValue()));
            }
            dirty = true;
        } else {
            for (Integer channel : channels) {
                c = redstoneChannels.getChannel(channel);
                if (c == null || ((Integer)this.values.get(channel).getRight()).intValue() == c.getValue()) continue;
                this.values.put(channel, (Pair<String, Integer>)Pair.of((Object)c.getName(), (Object)c.getValue()));
                dirty = true;
            }
        }
        if (dirty) {
            PacketSendRedstoneData message = PacketSendRedstoneData.create(this.values);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RFToolsUtilityMessages.sendToPlayer(message, (Player)serverPlayer);
            }
        }
    }
}

