/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.data.AnalogData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AnalogTileEntity
extends GenericTileEntity {
    private final LogicSupport support = new LogicSupport();
    @GuiValue(name="mul_eq")
    public static final Value<AnalogTileEntity, Float> MUL_EQUAL = Value.create((String)"mul_eq", (Type)Type.FLOAT, t -> Float.valueOf(t.getAnalogData().mulEqual()), (t, v) -> t.setAnalogData(t.getAnalogData().withMulEqual(v.floatValue())));
    @GuiValue(name="mul_less")
    public static final Value<AnalogTileEntity, Float> MUL_LESS = Value.create((String)"mul_less", (Type)Type.FLOAT, t -> Float.valueOf(t.getAnalogData().mulLess()), (t, v) -> t.setAnalogData(t.getAnalogData().withMulLess(v.floatValue())));
    @GuiValue(name="mul_greater")
    public static final Value<AnalogTileEntity, Float> MUL_GREATER = Value.create((String)"mul_greater", (Type)Type.FLOAT, t -> Float.valueOf(t.getAnalogData().mulGreater()), (t, v) -> t.setAnalogData(t.getAnalogData().withMulGreater(v.floatValue())));
    @GuiValue(name="add_eq")
    public static final Value<AnalogTileEntity, Integer> ADD_EQUAL = Value.create((String)"add_eq", (Type)Type.INTEGER, t -> t.getAnalogData().addEqual(), (t, v) -> t.setAnalogData(t.getAnalogData().withAddEqual((int)v)));
    @GuiValue(name="add_less")
    public static final Value<AnalogTileEntity, Integer> ADD_LESS = Value.create((String)"add_less", (Type)Type.INTEGER, t -> t.getAnalogData().addLess(), (t, v) -> t.setAnalogData(t.getAnalogData().withAddLess((int)v)));
    @GuiValue(name="add_greater")
    public static final Value<AnalogTileEntity, Integer> ADD_GREATER = Value.create((String)"add_greater", (Type)Type.INTEGER, t -> t.getAnalogData().addGreater(), (t, v) -> t.setAnalogData(t.getAnalogData().withAddGreater((int)v)));
    @Cap(type=CapType.CONTAINER)
    private static final Function<AnalogTileEntity, MenuProvider> screenHandler = be -> new DefaultContainerProvider("Analog").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_ANALOG, (GenericTileEntity)be)).setupSync((GenericTileEntity)be);
    private static final Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    public AnalogTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LogicBlockModule.ANALOG.be().get(), pos, state);
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsbase:logic/analog")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(AnalogTileEntity::new));
    }

    public AnalogData getAnalogData() {
        return (AnalogData)this.getData(LogicBlockModule.ANALOG_DATA);
    }

    public void setAnalogData(AnalogData data) {
        this.setData(LogicBlockModule.ANALOG_DATA, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRedstone(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (loopDetector.add(pos)) {
            try {
                LogicFacing facing = LogicSupport.getFacing((BlockState)state);
                Direction downSide = facing.getSide();
                Direction inputSide = facing.getInputSide();
                Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
                Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
                AnalogData data = this.getAnalogData();
                int inputStrength = this.support.getInputStrength(world, pos, inputSide);
                int inputLeft = this.support.getInputStrength(world, pos, leftSide);
                int inputRight = this.support.getInputStrength(world, pos, rightSide);
                int outputStrength = inputLeft == inputRight ? (int)((float)inputStrength * data.mulEqual() + (float)data.addEqual()) : (inputLeft < inputRight ? (int)((float)inputStrength * data.mulLess() + (float)data.addLess()) : (int)((float)inputStrength * data.mulGreater() + (float)data.addGreater()));
                if (outputStrength > 15) {
                    outputStrength = 15;
                } else if (outputStrength < 0) {
                    outputStrength = 0;
                }
                int oldPower = this.support.getPowerOutput();
                this.support.setRedstoneState((GenericTileEntity)this, outputStrength);
                if (oldPower != outputStrength) {
                    world.updateNeighborsAt(pos, this.getBlockState().getBlock());
                }
            }
            finally {
                loopDetector.remove(pos);
            }
        }
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }
}

