/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.recipes;

import java.util.Optional;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.BaseShapedRecipe;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.spawner.items.SyringeItem;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class SyringeBasedRecipe
extends BaseShapedRecipe {
    private final ResourceLocation mobId;
    private final int syringeIndex;

    public SyringeBasedRecipe(String group, ShapedRecipePattern pattern, ItemStack result, ResourceLocation mobId, int syringeIndex) {
        super(group, CraftingBookCategory.MISC, pattern, result);
        this.mobId = mobId;
        this.syringeIndex = syringeIndex;
    }

    public SyringeBasedRecipe(ShapedRecipe base, ResourceLocation mobId, int syringeIndex) {
        super(base.getGroup(), base.category(), base.pattern, base.getResultItem(null));
        this.mobId = mobId;
        this.syringeIndex = syringeIndex;
    }

    public SyringeBasedRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, ResourceLocation mobId, int syringeIndex) {
        super(group, CraftingBookCategory.MISC, new ShapedRecipePattern(width, height, SyringeBasedRecipe.addMob(ingredients, mobId, syringeIndex), Optional.empty()), result);
        this.mobId = mobId;
        this.syringeIndex = syringeIndex;
    }

    public SyringeBasedRecipe(ShapedRecipe other, ResourceLocation mobId, int syringeIndex, ItemStack result) {
        super(other.getGroup(), other.category(), new ShapedRecipePattern(other.getWidth(), other.getHeight(), SyringeBasedRecipe.addMob((NonNullList<Ingredient>)other.getIngredients(), mobId, syringeIndex), Optional.empty()), result);
        this.mobId = mobId;
        this.syringeIndex = syringeIndex;
    }

    private static NonNullList<Ingredient> addMob(NonNullList<Ingredient> input, ResourceLocation mobId, int syringeIndex) {
        NonNullList output = NonNullList.withSize((int)input.size(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < input.size(); ++i) {
            Ingredient ingredient = (Ingredient)input.get(i);
            if (syringeIndex == i) {
                if (!ingredient.isEmpty() && ingredient.getItems().length > 0 && ingredient.getItems()[0].getItem() instanceof SyringeItem) {
                    ItemStack syringe = SyringeItem.createMobSyringe(mobId);
                    ingredient = Ingredient.of((ItemStack[])new ItemStack[]{syringe});
                } else {
                    throw new RuntimeException("Bad recipe. Index " + syringeIndex + " does not point to syringe!");
                }
            }
            output.set(i, (Object)ingredient);
        }
        return output;
    }

    public boolean matches(@Nonnull CraftingInput inv, @Nonnull Level level) {
        boolean matches = super.matches(inv, level);
        if (matches) {
            for (int i = 0; i < inv.width() * inv.height(); ++i) {
                ItemStack stack = inv.getItem(i);
                if (!(stack.getItem() instanceof SyringeItem)) continue;
                ResourceLocation mob = SyringeItem.getMobId(stack);
                if (mob == null || !mob.equals((Object)this.mobId)) {
                    return false;
                }
                int amount = SyringeItem.getLevel(stack);
                if (amount >= 100) continue;
                return false;
            }
        }
        return matches;
    }

    public ResourceLocation getMobId() {
        return this.mobId;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return EnvironmentalModule.SYRINGE_SERIALIZER.get();
    }

    public int getSyringeIndex() {
        return this.syringeIndex;
    }
}

