/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalMode;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.playerprops.BuffProperties;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class PotionEffectModule
implements EnvironmentModule {
    public static final int MAXTICKS = 180;
    private final Holder<MobEffect> potion;
    private final int amplifier;
    private boolean active = false;
    private int ticks = 180;

    public PotionEffectModule(String potionname, int amplifier) {
        this.potion = BuiltInRegistries.MOB_EFFECT.getHolderOrThrow(ResourceKey.create((ResourceKey)BuiltInRegistries.MOB_EFFECT.key(), (ResourceLocation)ResourceLocation.parse((String)potionname)));
        this.amplifier = amplifier;
    }

    protected abstract PlayerBuff getBuff();

    protected boolean allowedForPlayers() {
        return true;
    }

    @Override
    public void tick(Level world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        if (!this.active) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 180;
        EnvironmentalMode mode = controllerTileEntity.getMode();
        switch (mode) {
            case MODE_BLACKLIST: 
            case MODE_WHITELIST: {
                if (!this.allowedForPlayers()) break;
                this.processPlayers(world, pos, radius, miny, maxy, controllerTileEntity);
                break;
            }
            case MODE_HOSTILE: 
            case MODE_PASSIVE: 
            case MODE_MOBS: 
            case MODE_ALL: {
                this.processEntities(world, pos, radius, miny, maxy, controllerTileEntity);
            }
        }
    }

    private void processPlayers(Level world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        double maxsqdist = radius * radius;
        ArrayList players = new ArrayList(world.players());
        for (Player player : players) {
            double py = player.getY();
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = player.getX();
            double pz = player.getZ();
            double sqdist = (px - (double)pos.getX()) * (px - (double)pos.getX()) + (pz - (double)pos.getZ()) * (pz - (double)pos.getZ());
            if (!(sqdist < maxsqdist) || !controllerTileEntity.isPlayerAffected(player)) continue;
            player.addEffect(new MobEffectInstance(this.potion, 540, this.amplifier, true, false));
            PlayerBuff buff = this.getBuff();
            if (buff == null) continue;
            BuffProperties.addBuffToPlayer(player, buff, 180);
        }
    }

    private void processEntities(Level world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        double maxsqdist = radius * radius;
        List entities = world.getEntities((EntityTypeTest)new EntityTypeTest<Entity, LivingEntity>(this){

            @Nullable
            public LivingEntity tryCast(Entity pEntity) {
                if (pEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)pEntity;
                    return livingEntity;
                }
                return null;
            }

            public Class<? extends Entity> getBaseClass() {
                return LivingEntity.class;
            }
        }, new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius)), Objects::nonNull);
        for (LivingEntity entity : entities) {
            PlayerBuff buff;
            double py = entity.getY();
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = entity.getX();
            double pz = entity.getZ();
            double sqdist = (px - (double)pos.getX()) * (px - (double)pos.getX()) + (pz - (double)pos.getZ()) * (pz - (double)pos.getZ());
            if (!(sqdist < maxsqdist)) continue;
            if (controllerTileEntity.isEntityAffected((Entity)entity)) {
                if (entity instanceof Player && !this.allowedForPlayers()) continue;
                entity.addEffect(new MobEffectInstance(this.potion, 540, this.amplifier, true, false));
                buff = this.getBuff();
                if (buff == null || !(entity instanceof Player)) continue;
                BuffProperties.addBuffToPlayer((Player)entity, buff, 180);
                continue;
            }
            if (!(entity instanceof Player) || (buff = this.getBuff()) == null) continue;
            BuffProperties.addBuffToPlayer((Player)entity, buff, 180);
        }
    }

    @Override
    public boolean apply(Level world, BlockPos pos, LivingEntity entity, int duration) {
        entity.addEffect(new MobEffectInstance(this.potion, duration, this.amplifier, true, false));
        return true;
    }

    @Override
    public void activate(boolean a) {
        if (this.active == a) {
            return;
        }
        this.active = a;
        this.ticks = 1;
    }

    public static PotionEffectModule create(String name, int amplifier, final PlayerBuff buff, final double rfPerTick) {
        return new PotionEffectModule(name, amplifier){

            @Override
            protected PlayerBuff getBuff() {
                return buff;
            }

            @Override
            public float getRfPerTick() {
                return (float)rfPerTick;
            }
        };
    }

    public static PotionEffectModule create(String name, int amplifier, final PlayerBuff buff, final double rfPerTick, final Supplier<Boolean> isAllowed) {
        return new PotionEffectModule(name, amplifier){

            @Override
            protected PlayerBuff getBuff() {
                return buff;
            }

            @Override
            public float getRfPerTick() {
                return (float)rfPerTick;
            }

            @Override
            protected boolean allowedForPlayers() {
                return (Boolean)isAllowed.get();
            }
        };
    }
}

