/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import net.minecraft.data.BlockFamily;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class GenericWoodStorageRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    private final ShapedRecipe compose;

    public GenericWoodStorageRecipe(ShapedRecipe compose) {
        super(compose.getGroup(), compose.category(), compose.pattern, compose.result);
        this.compose = compose;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public boolean matches(CraftingInput input, Level level) {
        return super.matches(input, level) && this.hasMixedOrNonCustomWood(input);
    }

    private TopLeftCornerCoords getTopLeftCornerCoords(CraftingInput input) {
        if (this.getHeight() * this.getWidth() == input.size()) {
            return new TopLeftCornerCoords(0, 0);
        }
        int minRow = Integer.MAX_VALUE;
        int minCol = Integer.MAX_VALUE;
        for (int row = 0; row < input.height() - this.getHeight(); ++row) {
            for (int col = 0; col < input.width() - this.getWidth(); ++col) {
                if (input.getItem(col + row * input.width()).isEmpty()) continue;
                minRow = Math.min(minRow, row);
                minCol = Math.min(minCol, col);
            }
        }
        return new TopLeftCornerCoords(minCol, minRow);
    }

    private boolean hasMixedOrNonCustomWood(CraftingInput input) {
        TopLeftCornerCoords topLeftCorner = this.getTopLeftCornerCoords(input);
        LinkedHashSet<BlockFamily> customFamilies = new LinkedHashSet<BlockFamily>();
        for (int row = topLeftCorner.top; row < topLeftCorner.top + this.getHeight(); ++row) {
            for (int col = topLeftCorner.left; col < topLeftCorner.left + this.getWidth(); ++col) {
                int slot = col + row * input.width();
                ItemStack itemStack = input.getItem(slot);
                if (itemStack.isEmpty() || ((Ingredient)this.getIngredients().get(slot)).getItems().length < 2) continue;
                Optional<BlockFamily> customBlockFamily = this.getCustomBlockFamily(itemStack.getItem());
                if (customBlockFamily.isEmpty()) {
                    return true;
                }
                customFamilies.add(customBlockFamily.get());
            }
        }
        return customFamilies.size() > 1;
    }

    private Optional<BlockFamily> getCustomBlockFamily(Item item) {
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        BlockItem blockItem = (BlockItem)item;
        for (BlockFamily family : WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.values()) {
            if (blockItem.getBlock() != family.getBaseBlock() && blockItem.getBlock() != family.get(BlockFamily.Variant.SLAB)) continue;
            return Optional.of(family);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModBlocks.GENERIC_WOOD_STORAGE_RECIPE_SERIALIZER.get();
    }

    private record TopLeftCornerCoords(int left, int top) {
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, GenericWoodStorageRecipe> {
        public Serializer() {
            super(GenericWoodStorageRecipe::new, RecipeSerializer.SHAPED_RECIPE);
        }
    }
}

