/*
 * Decompiled with CFR 0.152.
 */
package com.neuvillette.ae2ct.gui;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.crafting.CraftingPlanSummaryEntry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.neuvillette.ae2ct.Config;
import com.neuvillette.ae2ct.api.CraftingTreeHelper;
import com.neuvillette.ae2ct.api.RecipeHelper;
import com.neuvillette.ae2ct.api.ScreenshotHelper;
import com.neuvillette.ae2ct.api.ToolTipText;
import java.awt.Point;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;

public class CraftingTreeWidget {
    private RecipeHelper data;
    protected final AEBaseScreen<?> screen;
    private CompletableFuture<CraftingTreeHelper.NodeManager> future = null;
    private CraftingTreeHelper helper;
    private int outputX = 20;
    private int outputY = 30;
    private int spacingX = 30;
    private int spacingY = 30;
    private int stackLength = 8;
    private float scroll = 1.0f;
    private CraftingTreeHelper.Node selectedNode = null;
    private int selectedNodeIdx = 0;

    public CraftingTreeWidget(AEBaseScreen<?> screen, RecipeHelper data, List<CraftingPlanSummaryEntry> entries) {
        this.screen = screen;
        this.data = data;
        this.helper = new CraftingTreeHelper(data, entries);
        this.future = CompletableFuture.supplyAsync(() -> this.helper.build());
    }

    public void draw(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int color = FastColor.ARGB32.color((int)100, (int)114, (int)114, (int)114);
        Rect2i board = new Rect2i(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 20, 330, 190);
        guiGraphics.enableScissor(board.getX(), board.getY(), board.getX() + board.getWidth(), board.getY() + board.getHeight());
        GenericStack output = this.data.output;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        CraftingTreeHelper.NodeManager nodeManager = null;
        try {
            if (this.future.isDone()) {
                nodeManager = this.future.get();
                if ((Boolean)Config.USE_COMPACT_TREE.get() != this.helper.now_mode) {
                    this.helper.buildNodePosition(nodeManager.root, nodeManager);
                }
                poseStack.scale(this.scroll, this.scroll, this.scroll);
                this.drawNode(guiGraphics, nodeManager.root);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        poseStack.popPose();
        guiGraphics.disableScissor();
        Point p = this.getMousePoint(guiGraphics, mouseX, mouseY);
        if (nodeManager != null && nodeManager.map.containsKey(p) && nodeManager.map.get(p) != null) {
            CraftingTreeHelper.Node node = nodeManager.map.get(p);
            GenericStack stack = node.stack;
            int x = mouseX - this.screen.getGuiLeft() + 10;
            int y = mouseY - this.screen.getGuiTop() + 10;
            List lines = AEKeyRendering.getTooltip((AEKey)stack.what());
            CraftingTreeHelper.AmountHelper a = node.amountHelper;
            if (stack.what() == this.data.output.what()) {
                lines.add(ToolTipText.OutputAmount.text(new Object[]{stack.what().formatAmount(node.amount.longValue(), AmountFormat.FULL)}));
            } else if (node.subNodes == null || node.subNodes.isEmpty()) {
                lines.add(ToolTipText.InputAmount.text(new Object[]{stack.what().formatAmount(node.amount.longValue(), AmountFormat.FULL)}));
                lines.add(ToolTipText.Info.text());
                if (a.storedAmount > 0L) {
                    lines.add(ToolTipText.StoredAmount.text(new Object[]{stack.what().formatAmount(a.storedAmount, AmountFormat.FULL)}));
                }
                if (a.missingAmount > 0L) {
                    lines.add(ToolTipText.MissingAmount.text(new Object[]{stack.what().formatAmount(a.missingAmount, AmountFormat.FULL)}));
                }
            } else {
                lines.add(ToolTipText.MiddenAmount.text(new Object[]{stack.what().formatAmount(node.amount.longValue(), AmountFormat.FULL)}));
                lines.add(ToolTipText.Info.text());
                if (a.storedAmount > 0L) {
                    lines.add(ToolTipText.StoredAmount.text(new Object[]{stack.what().formatAmount(a.storedAmount, AmountFormat.FULL)}));
                }
                if (a.craftAmount > 0L) {
                    lines.add(ToolTipText.CraftingAmount.text(new Object[]{stack.what().formatAmount(a.craftAmount, AmountFormat.FULL)}));
                }
            }
            this.screen.drawTooltipWithHeader(guiGraphics, mouseX - this.screen.getGuiLeft(), mouseY - this.screen.getGuiTop(), lines);
        }
    }

    private void drawNode(GuiGraphics guiGraphics, CraftingTreeHelper.Node node) {
        GenericStack stack = node.stack;
        int color = FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0);
        int x = node.point.x * this.spacingX + this.outputX;
        int y = node.point.y * this.spacingY + this.outputY;
        if ((float)x * this.scroll > (float)(this.screen.getGuiLeft() + this.screen.width + 10) || (float)y * this.scroll > (float)(this.screen.getGuiTop() + this.screen.height + 10)) {
            return;
        }
        if (node.subNodes != null && !node.subNodes.isEmpty()) {
            guiGraphics.vLine(x + this.stackLength, y + this.stackLength, y + this.stackLength + this.spacingY / 2, color);
        }
        if (node.amountHelper.missingAmount <= 0L) {
            guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"ae2ct", (String)"icon.png"), x - 3, y - 3, 0, 0, 22, 22);
        } else {
            guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"ae2ct", (String)"icon.png"), x - 3, y - 3, 0, 22, 22, 22);
        }
        AEKeyRendering.drawInGui((Minecraft)Minecraft.getInstance(), (GuiGraphics)guiGraphics, (int)x, (int)y, (AEKey)stack.what());
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        Font font = Minecraft.getInstance().font;
        int fontX = font.width(CraftingTreeWidget.getDrawAmount(node));
        Objects.requireNonNull(font);
        int fontY = 9;
        float scale = 0.4f;
        poseStack.scale(scale, scale, scale);
        guiGraphics.drawString(font, CraftingTreeWidget.getDrawAmount(node), ((float)(x + 18) - (float)fontX * scale) / scale, ((float)(y + 18) - (float)fontY * scale) / scale, color, false);
        poseStack.popPose();
        if (node.subNodes == null || node.subNodes.isEmpty()) {
            return;
        }
        Point last = new Point(0, 0);
        for (CraftingTreeHelper.Node child : node.subNodes) {
            Point p = child.point;
            int pX = p.x * this.spacingX + this.outputX;
            int pY = p.y * this.spacingY + this.outputY;
            guiGraphics.vLine(pX + this.stackLength, y + this.stackLength + this.spacingY / 2, pY + this.stackLength, color);
            this.drawNode(guiGraphics, child);
            if (last.x >= p.x) continue;
            last = p;
        }
        guiGraphics.hLine(x + this.stackLength, last.x * this.spacingX + this.outputX + this.stackLength, y + this.stackLength + this.spacingY / 2, color);
    }

    public void screenShot() {
        try {
            if (this.future.isDone()) {
                CraftingTreeHelper.NodeManager nodeManager = this.future.get();
                ScreenshotHelper.Screenshot(nodeManager, ((AEBaseMenu)this.screen.getMenu()).getPlayer());
            } else {
                Player player = ((AEBaseMenu)this.screen.getMenu()).getPlayer();
                player.sendSystemMessage((Component)Component.translatable((String)"ae2ct.screenshot.noready"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDrawAmount(CraftingTreeHelper.Node node) {
        Long amount = node.amount;
        if (node.stack.what() instanceof AEFluidKey) {
            if (amount >= 1000L) {
                return CraftingTreeWidget.formatNumber((double)amount.longValue() / 1000.0) + "B";
            }
            return String.valueOf(amount);
        }
        if (amount >= 1000000000L) {
            return CraftingTreeWidget.formatNumber((double)amount.longValue() / 1.0E9) + "G";
        }
        if (amount >= 1000000L) {
            return CraftingTreeWidget.formatNumber((double)amount.longValue() / 1000000.0) + "M";
        }
        if (amount >= 1000L) {
            return CraftingTreeWidget.formatNumber((double)amount.longValue() / 1000.0) + "k";
        }
        return String.valueOf(amount);
    }

    public static String formatNumber(double number) {
        if (number == (double)((long)number)) {
            return String.format("%d", (long)number);
        }
        return String.format("%.1f", number);
    }

    private Rect2i getArea() {
        return new Rect2i(10, 20, 330, 190);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isMouseOutScreen(mouseX, mouseY)) {
            return true;
        }
        this.scroll += (float)(deltaY * 0.1);
        if (this.scroll <= 0.1f) {
            this.scroll = 0.1f;
        }
        if (this.scroll >= 10.0f) {
            this.scroll = 10.0f;
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.isMouseOutScreen(mouseX, mouseY)) {
            return true;
        }
        if (mouseButton == 1 || mouseButton == 0) {
            if (this.scroll <= 0.3f) {
                this.outputX += (int)(dragX * 2.5);
                this.outputY += (int)(dragY * 2.5);
            } else {
                this.outputX += (int)dragX;
                this.outputY += (int)dragY;
            }
        }
        return true;
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (btn == 2) {
            this.scroll = 1.0f;
            this.outputX = 20;
            this.outputY = 30;
        }
        return true;
    }

    private boolean isMouseOutScreen(double mouseX, double mouseY) {
        if (mouseX - (double)this.screen.getGuiLeft() < (double)this.getArea().getX() || mouseX - (double)this.screen.getGuiLeft() > (double)(this.getArea().getX() + this.getArea().getWidth())) {
            return true;
        }
        return mouseY - (double)this.screen.getGuiTop() < (double)this.getArea().getY() || mouseY - (double)this.screen.getGuiTop() > (double)(this.getArea().getY() + this.getArea().getHeight());
    }

    private Point getMousePoint(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        try {
            if (this.isMouseOutScreen(mouseX, mouseY)) {
                return new Point(-1, -1);
            }
            int x = (int)(mouseX - (double)this.screen.getGuiLeft() - (double)((float)this.outputX * this.scroll));
            int y = (int)(mouseY - (double)this.screen.getGuiTop() - (double)((float)this.outputY * this.scroll));
            int sizeX = (int)((float)this.spacingX * this.scroll);
            int sizeY = (int)((float)this.spacingY * this.scroll);
            int i = x / sizeX;
            int j = y / sizeY;
            int left = (int)((float)(i * this.spacingX) * this.scroll);
            int top = (int)((float)(j * this.spacingY) * this.scroll);
            int right = (int)((float)(i * this.spacingX + this.stackLength * 2) * this.scroll);
            int bottom = (int)((float)(j * this.spacingY + this.stackLength * 2) * this.scroll);
            if (x > left && x < right && y > top && y < bottom) {
                return new Point(i, j);
            }
            return new Point(-1, -1);
        }
        catch (Exception e) {
            return new Point(-1, -1);
        }
    }

    private CraftingTreeHelper.Node getSelectedNode(CraftingTreeHelper.NodeManager manager) {
        if (this.selectedNode == null) {
            this.selectedNode = manager.root;
        }
        return this.selectedNode;
    }

    private void updatePosition() {
        if (this.selectedNode != null) {
            this.outputX = 20 - this.selectedNode.point.x * this.spacingX;
            this.outputY = 30 - this.selectedNode.point.y * this.spacingY;
        }
    }

    public void keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.future.isDone()) {
            try {
                CraftingTreeHelper.NodeManager nodeManager = this.future.get();
                switch (keyCode) {
                    case 262: {
                        CraftingTreeHelper.Node p = this.getSelectedNode((CraftingTreeHelper.NodeManager)nodeManager).parent;
                        if (p != null && this.selectedNodeIdx + 1 < p.subNodes.size()) {
                            ++this.selectedNodeIdx;
                            this.selectedNode = p.subNodes.get(this.selectedNodeIdx);
                        }
                        this.updatePosition();
                        break;
                    }
                    case 263: {
                        CraftingTreeHelper.Node p = this.getSelectedNode((CraftingTreeHelper.NodeManager)nodeManager).parent;
                        if (p != null && this.selectedNodeIdx > 0) {
                            --this.selectedNodeIdx;
                            this.selectedNode = p.subNodes.get(this.selectedNodeIdx);
                        }
                        this.updatePosition();
                        break;
                    }
                    case 265: {
                        CraftingTreeHelper.Node p = this.getSelectedNode((CraftingTreeHelper.NodeManager)nodeManager).parent;
                        if (p != null) {
                            this.selectedNode = p;
                            if (this.selectedNode.parent != null) {
                                this.selectedNodeIdx = this.selectedNode.parent.subNodes.indexOf(this.selectedNode);
                            }
                        }
                        this.updatePosition();
                        break;
                    }
                    case 264: {
                        CraftingTreeHelper.Node node = this.getSelectedNode(nodeManager);
                        if (!node.subNodes.isEmpty()) {
                            this.selectedNode = node.subNodes.get(0);
                            this.selectedNodeIdx = 0;
                        }
                        this.updatePosition();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

