/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.crafting;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.craftingtweaks.crafting.CraftingContext;
import net.blay09.mods.craftingtweaks.crafting.IngredientCacheHint;
import net.blay09.mods.craftingtweaks.crafting.IngredientProvider;
import net.blay09.mods.craftingtweaks.crafting.IngredientToken;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class CraftingOperation {
    private final CraftingContext context;
    private final Recipe<?> recipe;
    private final Multimap<IngredientTokenKey, IngredientToken> tokensByIngredient = ArrayListMultimap.create();
    private final List<IngredientToken> ingredientTokens = new ArrayList<IngredientToken>();
    private final List<Ingredient> missingIngredients = new ArrayList<Ingredient>();
    private NonNullList<ItemStack> lockedInputs;
    private int missingIngredientsMask;

    public CraftingOperation(CraftingContext context, RecipeHolder<Recipe<?>> recipe) {
        this.context = context;
        this.recipe = recipe.value();
    }

    public CraftingOperation withLockedInputs(@Nullable NonNullList<ItemStack> lockedInputs) {
        this.lockedInputs = lockedInputs;
        return this;
    }

    public CraftingOperation prepare() {
        this.tokensByIngredient.clear();
        this.ingredientTokens.clear();
        this.missingIngredients.clear();
        this.missingIngredientsMask = 0;
        NonNullList ingredients = this.recipe.getIngredients();
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.isEmpty()) {
                this.ingredientTokens.add(IngredientToken.EMPTY);
                continue;
            }
            ItemStack lockedInput = this.lockedInputs != null ? (ItemStack)this.lockedInputs.get(i) : ItemStack.EMPTY;
            IngredientToken ingredientToken = this.accountForIngredient(ingredient, lockedInput);
            if (ingredientToken != null) {
                if (ingredient.getItems().length <= 1) continue;
                if (this.lockedInputs == null) {
                    this.lockedInputs = NonNullList.withSize((int)this.recipe.getIngredients().size(), (Object)ItemStack.EMPTY);
                }
                this.lockedInputs.set(i, (Object)ingredientToken.peek());
                continue;
            }
            this.missingIngredients.add(ingredient);
            this.missingIngredientsMask |= 1 << i;
        }
        return this;
    }

    @Nullable
    private IngredientToken accountForIngredient(Ingredient ingredient, ItemStack lockedInput) {
        IngredientProvider ingredientProvider;
        IngredientToken ingredientToken;
        List<IngredientProvider> ingredientProviders = this.context.getIngredientProviders();
        int cachedProviderIndex = this.context.getCachedIngredientProviderIndexFor(ingredient);
        if (cachedProviderIndex != -1 && (ingredientToken = this.accountForIngredient(cachedProviderIndex, ingredientProvider = ingredientProviders.get(cachedProviderIndex), ingredient, lockedInput, true)) != null) {
            return ingredientToken;
        }
        for (int j = 0; j < ingredientProviders.size(); ++j) {
            IngredientProvider ingredientProvider2 = ingredientProviders.get(j);
            IngredientToken ingredientToken2 = this.accountForIngredient(j, ingredientProvider2, ingredient, lockedInput, false);
            if (ingredientToken2 == null) continue;
            return ingredientToken2;
        }
        return null;
    }

    @Nullable
    private IngredientToken accountForIngredient(int ingredientProviderIndex, IngredientProvider ingredientProvider, Ingredient ingredient, ItemStack lockedInput, boolean useCache) {
        IngredientCacheHint cacheHint;
        IngredientTokenKey ingredientTokenKey = new IngredientTokenKey(ingredientProviderIndex, ingredient.getStackingIds());
        Collection scopedIngredientTokens = this.tokensByIngredient.get((Object)ingredientTokenKey);
        IngredientToken ingredientToken = this.findIngredient(ingredientProvider, ingredient, lockedInput, scopedIngredientTokens, cacheHint = useCache ? this.context.getCacheHintFor(ingredientTokenKey) : IngredientCacheHint.NONE);
        if (ingredientToken != null) {
            this.tokensByIngredient.put((Object)ingredientTokenKey, (Object)ingredientToken);
            this.context.cache(ingredientTokenKey, ingredientProviderIndex, ingredientProvider.getCacheHint(ingredientToken));
            this.ingredientTokens.add(ingredientToken);
            return ingredientToken;
        }
        return null;
    }

    @Nullable
    private IngredientToken findIngredient(IngredientProvider ingredientProvider, Ingredient ingredient, ItemStack lockedInput, Collection<IngredientToken> ingredientTokens, IngredientCacheHint cacheHint) {
        IngredientToken ingredientToken = lockedInput.isEmpty() ? ingredientProvider.findIngredient(ingredient, ingredientTokens, cacheHint) : ingredientProvider.findIngredient(lockedInput, ingredientTokens, cacheHint);
        return ingredientToken;
    }

    public boolean canCraft() {
        return this.missingIngredients.isEmpty();
    }

    public NonNullList<ItemStack> getLockedInputs() {
        return this.lockedInputs;
    }

    public List<IngredientToken> getIngredientTokens() {
        return this.ingredientTokens;
    }

    public List<Ingredient> getMissingIngredients() {
        return this.missingIngredients;
    }

    public int getMissingIngredientsMask() {
        return this.missingIngredientsMask;
    }

    public record IngredientTokenKey(int providerIndex, IntList stackingIds) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IngredientTokenKey that = (IngredientTokenKey)o;
            return this.providerIndex == that.providerIndex && Objects.equals(this.stackingIds, that.stackingIds);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.providerIndex, this.stackingIds);
        }
    }
}

