/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.override.datagen;

import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.override.content.registries.OverrideContent;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class OverrideRecipeDataGen
extends RecipeProvider {
    public OverrideRecipeDataGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(@NotNull RecipeOutput finished) {
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.STONE_BRICKS, OverrideContent.Block.StoneBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.CHISELED_STONE_BRICKS, OverrideContent.Block.ChiseledStoneBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.MOSSY_STONE_BRICKS, OverrideContent.Block.MossyStoneBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.CHISELED_SANDSTONE, OverrideContent.Block.ChiseledSandstone);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.CHISELED_RED_SANDSTONE, OverrideContent.Block.ChiseledRedSandstone);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.PRISMARINE_BRICKS, OverrideContent.Block.PrismarineBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.MUD_BRICKS, OverrideContent.Block.MudBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.BRICKS, OverrideContent.Block.Bricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.POLISHED_DEEPSLATE, OverrideContent.Block.DeepslateBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.POLISHED_BLACKSTONE, OverrideContent.Block.PolishedBlackstoneBricks);
        this.addXychoriumRecipe(finished, (TagKey<Item>)ItemTags.PLANKS, OverrideContent.Block.ChiseledWoodPillar);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.DEEPSLATE_TILES, OverrideContent.Block.DeepslateTiles);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.CHISELED_DEEPSLATE, OverrideContent.Block.ChiseledDeepslate);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.CHISELED_NETHER_BRICKS, OverrideContent.Block.ChiseledNetherBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.CHISELED_POLISHED_BLACKSTONE, OverrideContent.Block.ChiseledPolishedBlackstone);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.GILDED_BLACKSTONE, OverrideContent.Block.GildedBlackstone);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.END_STONE_BRICKS, OverrideContent.Block.EndStoneBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.CRYING_OBSIDIAN, OverrideContent.Block.CryingObsidian);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.PURPUR_PILLAR, OverrideContent.Block.PurpurPillar);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.PURPUR_BLOCK, OverrideContent.Block.PurpurBlock);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.QUARTZ_BRICKS, OverrideContent.Block.QuartzBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.NETHER_BRICKS, OverrideContent.Block.NetherBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.RED_NETHER_BRICKS, OverrideContent.Block.RedNetherBricks);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.MAGMA_BLOCK, OverrideContent.Block.Magma);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.CHISELED_TUFF, OverrideContent.Block.ChiseledTuff);
        this.addXychoriumRecipe(finished, (ItemLike)Blocks.CHISELED_TUFF_BRICKS, OverrideContent.Block.ChiseledTuffBricks);
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.SmoothStoneGroup.tag(), (ItemLike)Items.SMOOTH_STONE);
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.SmoothStoneGroup.tag(), (ItemLike)OverrideContent.Block.SmoothSmoothStone);
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.TuffGroup.tag(), (ItemLike)Items.POLISHED_TUFF);
        this.buildStoneCutting(finished, (TagKey<Item>)XyCraftTags.Items.TuffGroup.tag(), (ItemLike)OverrideContent.Block.SmoothPolishedTuff);
    }

    public void buildStoneCutting(@NotNull RecipeOutput finished, TagKey<Item> in, ItemLike out) {
        String outName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)out.asItem())).getPath();
        SingleItemRecipeBuilder.stonecutting((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.of(in), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{out})), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)out).unlockedBy("has_for_" + outName, OverrideRecipeDataGen.has(in)).save(finished, "xycraft_world:stonecutting/" + outName);
    }

    public void addXychoriumRecipe(RecipeOutput finished, TagKey<Item> in, EnumMap<XyCraftColors, BlockContent> cloudBlocks) {
        cloudBlocks.forEach((customColors, blockContent) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)blockContent.block(), (int)2).define(Character.valueOf('1'), (ItemLike)((ItemContent)WorldContent.Item.XychoriumGem.get(customColors)).item()).define(Character.valueOf('2'), in).pattern("12").pattern("21").unlockedBy("has_" + String.valueOf(in), OverrideRecipeDataGen.has((TagKey)in)).save(finished, "xycraft_override:shaped/" + blockContent.id().getPath());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)blockContent.block(), (int)2).define(Character.valueOf('2'), (ItemLike)((ItemContent)WorldContent.Item.XychoriumGem.get(customColors)).item()).define(Character.valueOf('1'), in).pattern("12").pattern("21").unlockedBy("has_" + String.valueOf(in), OverrideRecipeDataGen.has((TagKey)in)).save(finished, "xycraft_override:shaped/" + blockContent.id().getPath() + "_r");
        });
    }

    public void addXychoriumRecipe(RecipeOutput finished, ItemLike in, EnumMap<XyCraftColors, BlockContent> cloudBlocks) {
        cloudBlocks.forEach((customColors, blockContent) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)blockContent.block(), (int)2).define(Character.valueOf('1'), (ItemLike)((ItemContent)WorldContent.Item.XychoriumGem.get(customColors)).item()).define(Character.valueOf('2'), in).pattern("12").pattern("21").unlockedBy("has_" + String.valueOf(in.asItem()), OverrideRecipeDataGen.has((ItemLike)in)).save(finished, "xycraft_override:shaped/" + blockContent.id().getPath()));
    }
}

