/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util.biome;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import me.pepperbell.continuity.client.util.biome.BiomeHolder;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7924;

public final class BiomeHolderManager {
    private static final Map<class_2960, BiomeHolder> HOLDER_CACHE = new Object2ObjectOpenHashMap();
    private static final Set<Runnable> REFRESH_CALLBACKS = new ReferenceOpenHashSet();
    private static class_5455 registryManager;

    public static BiomeHolder getOrCreateHolder(class_2960 id) {
        return HOLDER_CACHE.computeIfAbsent(id, BiomeHolder::new);
    }

    public static void addRefreshCallback(Runnable callback) {
        REFRESH_CALLBACKS.add(callback);
    }

    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            registryManager = handler.method_29091();
            BiomeHolderManager.refreshHolders();
        });
    }

    public static void refreshHolders() {
        if (registryManager == null) {
            return;
        }
        Object2ObjectOpenHashMap compactIdMap = new Object2ObjectOpenHashMap();
        class_2378 biomeRegistry = registryManager.method_30530(class_7924.field_41236);
        for (class_2960 id : biomeRegistry.method_10235()) {
            class_2960 compactId;
            String compactPath;
            String path = id.method_12832();
            if (path.equals(compactPath = path.replace("_", "")) || biomeRegistry.method_10250(compactId = new class_2960(id.method_12836(), compactPath))) continue;
            compactIdMap.put(compactId, id);
        }
        for (BiomeHolder holder : HOLDER_CACHE.values()) {
            holder.refresh((class_2378<class_1959>)biomeRegistry, (Map<class_2960, class_2960>)compactIdMap);
        }
        for (Runnable callback : REFRESH_CALLBACKS) {
            callback.run();
        }
    }

    public static void clearCache() {
        HOLDER_CACHE.clear();
        REFRESH_CALLBACKS.clear();
    }
}

