/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.config.SenderDetection;
import dzwdz.chat_heads.mixinterface.GuiMessageOwnerAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_2556;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7463;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static final String FORMAT_REGEX = "\u00a7.";
    public static final Logger LOGGER = LogManager.getLogger((String)"chat_heads");
    public static final class_2960 DISABLE_RESOURCE = new class_2960("chat_heads", "disable");
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @Nullable
    public static class_640 lastSender;
    public static boolean refreshing;
    @Nullable
    public static class_640 lineOwner;
    @Nullable
    public static class_640 refreshingLineOwner;
    public static volatile boolean serverSentUuid;
    public static volatile boolean serverDisabledChatHeads;
    public static final Set<class_2960> blendedHeadTextures;

    public static class_640 getLineOwner() {
        return refreshing ? refreshingLineOwner : lineOwner;
    }

    public static void resetLineOwner() {
        if (refreshing) {
            refreshingLineOwner = null;
        } else {
            lineOwner = null;
        }
    }

    public static void handleAddedMessage(class_2561 message, @Nullable class_2556.class_7602 bound, @Nullable class_640 playerInfo) {
        if (serverDisabledChatHeads) {
            lastSender = null;
            return;
        }
        if (CONFIG.senderDetection() != SenderDetection.HEURISTIC_ONLY) {
            if (playerInfo != null) {
                lastSender = playerInfo;
                serverSentUuid = true;
                return;
            }
            if (CONFIG.senderDetection() == SenderDetection.UUID_ONLY || serverSentUuid && CONFIG.smartHeuristics()) {
                lastSender = null;
                return;
            }
        }
        lastSender = ChatHeads.detectPlayer(message, bound);
    }

    @Nullable
    public static class_640 getOwner(@NotNull class_303.class_7590 guiMessage) {
        return ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
    }

    @Nullable
    public static class_640 getOwner(@NotNull class_303 guiMessage) {
        return ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
    }

    public static int getChatOffset(@NotNull class_303.class_7590 guiMessage) {
        return ChatHeads.getChatOffset(ChatHeads.getOwner(guiMessage));
    }

    public static int getChatOffset(@Nullable class_640 owner) {
        if (owner != null || CONFIG.offsetNonPlayerText() && !serverDisabledChatHeads) {
            return 10;
        }
        return 0;
    }

    @Nullable
    public static class_640 detectPlayer(class_2561 message, @Nullable class_2556.class_7602 bound) {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            return null;
        }
        class_2561 sender = ChatHeads.getSenderDecoration(bound);
        PlayerInfoCache playerInfoCache = new PlayerInfoCache(connection);
        playerInfoCache.collectProfileNames();
        class_640 player = ChatHeads.getTellReceiver(sender != null ? sender : message).map(playerInfoCache::get).orElse(null);
        if (player != null) {
            return player;
        }
        playerInfoCache.collectAllNames();
        if (sender != null) {
            return playerInfoCache.get(sender.getString());
        }
        return ChatHeads.scanForPlayerName(message.getString(), playerInfoCache);
    }

    private static Optional<String> getTellReceiver(class_2561 component) {
        return component.method_27658((style, string) -> {
            String cmd;
            class_2558 clickEvent = style.method_10970();
            if (clickEvent != null && (cmd = clickEvent.method_10844()).startsWith("/tell ")) {
                String name = cmd.substring("/tell ".length()).trim();
                return Optional.of(name);
            }
            return Optional.empty();
        }, class_2583.field_24360);
    }

    @Nullable
    private static class_2561 getSenderDecoration(@Nullable class_2556.class_7602 bound) {
        if (bound == null) {
            return null;
        }
        for (class_7463.class_7464 param : bound.comp_919().comp_792().comp_789()) {
            if (param != class_7463.class_7464.field_39220) continue;
            return bound.comp_920();
        }
        return null;
    }

    @Nullable
    private static class_640 scanForPlayerName(@NotNull String message, PlayerInfoCache playerInfoCache) {
        message = message.replaceAll(FORMAT_REGEX, "");
        HashMap<Integer, List<String>> namesByFirstCharacter = playerInfoCache.createNamesByFirstCharacterMap();
        boolean insideWord = false;
        int[] messageSeq = message.codePoints().toArray();
        for (int i = 0; i < messageSeq.length; ++i) {
            int c = messageSeq[i];
            if (insideWord && ChatHeads.isWordCharacter(c)) continue;
            for (String name : namesByFirstCharacter.getOrDefault(c, List.of())) {
                boolean nameIsFollowedByWord;
                int[] nameSeq = name.codePoints().toArray();
                if (i + nameSeq.length - 1 >= messageSeq.length) continue;
                boolean nameEndsAsWord = ChatHeads.isWordCharacter(nameSeq[nameSeq.length - 1]);
                boolean bl = nameIsFollowedByWord = i + nameSeq.length < messageSeq.length && ChatHeads.isWordCharacter(messageSeq[i + nameSeq.length]);
                if (nameEndsAsWord && nameIsFollowedByWord || !ChatHeads.containsSubsequenceAt(messageSeq, i, nameSeq)) continue;
                return playerInfoCache.get(name);
            }
            insideWord = ChatHeads.isWordCharacter(c);
        }
        return null;
    }

    private static boolean isWordCharacter(int codePoint) {
        return Character.isLetterOrDigit(codePoint) || codePoint == 95 || Character.getNumericValue(codePoint) != -1;
    }

    private static boolean containsSubsequenceAt(int[] sequence, int startIndex, int[] subsequence) {
        for (int j = 0; j < subsequence.length; ++j) {
            if (sequence[startIndex + j] == subsequence[j]) continue;
            return false;
        }
        return true;
    }

    public static class_1011 extractBlendedHead(class_1011 skin) {
        int xScale = skin.method_4307() / 64;
        int yScale = skin.method_4323() / 64;
        class_1011 head = new class_1011(8 * xScale, 8 * yScale, false);
        for (int y = 0; y < head.method_4323(); ++y) {
            for (int x = 0; x < head.method_4307(); ++x) {
                int headColor = skin.method_4315(8 * xScale + x, 8 * yScale + y);
                int hatColor = skin.method_4315(40 * xScale + x, 8 * yScale + y);
                head.method_4305(x, y, headColor);
                head.method_35624(x, y, hatColor);
            }
        }
        return head;
    }

    public static class_2960 getBlendedHeadLocation(class_2960 skinLocation) {
        return new class_2960(MOD_ID, skinLocation.method_12832());
    }

    public static void renderChatHead(class_332 guiGraphics, int x, int y, class_640 owner) {
        class_2960 skinLocation = owner.method_2968();
        if (blendedHeadTextures.contains(skinLocation)) {
            guiGraphics.method_25293(ChatHeads.getBlendedHeadLocation(skinLocation), x, y, 8, 8, 0.0f, 0.0f, 8, 8, 8, 8);
        } else {
            guiGraphics.method_25293(skinLocation, x, y, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.method_25293(skinLocation, x, y, 8, 8, 40.0f, 8.0f, 8, 8, 64, 64);
        }
    }

    static {
        serverSentUuid = false;
        serverDisabledChatHeads = false;
        blendedHeadTextures = new HashSet<class_2960>();
    }

    static class PlayerInfoCache {
        private final class_634 connection;
        private final Map<String, class_640> playerInfos = new HashMap<String, class_640>();
        private boolean collectedProfileNames = false;
        private boolean collectedEverything = false;

        public PlayerInfoCache(class_634 connection) {
            this.connection = connection;
        }

        public void collectProfileNames() {
            if (this.collectedProfileNames) {
                return;
            }
            this.collectedProfileNames = true;
            for (class_640 playerInfo : this.connection.method_2880()) {
                String profileName = playerInfo.method_2966().getName().replaceAll(ChatHeads.FORMAT_REGEX, "");
                this.playerInfos.put(profileName, playerInfo);
            }
        }

        public void collectAllNames() {
            if (this.collectedEverything) {
                return;
            }
            this.collectedEverything = true;
            this.collectProfileNames();
            for (class_640 class_6402 : this.connection.method_2880()) {
                if (class_6402.method_2971() == null) continue;
                String displayName = class_6402.method_2971().getString().replaceAll(ChatHeads.FORMAT_REGEX, "");
                this.playerInfos.putIfAbsent(displayName, class_6402);
            }
            for (Map.Entry entry : CONFIG.getNameAliases().entrySet()) {
                class_640 playerInfo = this.playerInfos.get(entry.getValue());
                if (playerInfo == null) continue;
                this.playerInfos.putIfAbsent((String)entry.getKey(), playerInfo);
            }
        }

        public HashMap<Integer, List<String>> createNamesByFirstCharacterMap() {
            HashMap<Integer, List<String>> namesByFirstCharacter = new HashMap<Integer, List<String>>();
            for (String name : this.playerInfos.keySet()) {
                namesByFirstCharacter.compute(name.codePointAt(0), (key, value) -> {
                    if (value == null) {
                        value = new ArrayList<String>();
                    }
                    value.add(name);
                    return value;
                });
            }
            return namesByFirstCharacter;
        }

        @Nullable
        public class_640 get(@NotNull String name) {
            return this.playerInfos.get(name);
        }

        public Set<String> getNames() {
            return this.playerInfos.keySet();
        }
    }
}

