/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compatibility.environment.probe;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterInfo;
import me.jellysquid.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterVendor;
import net.minecraft.class_156;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.util.ExecutingCommand;

public class GraphicsAdapterProbe {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-GraphicsAdapterProbe");
    private static List<GraphicsAdapterInfo> ADAPTERS;

    public static void findAdapters() {
        List<GraphicsAdapterInfo> results;
        LOGGER.info("Searching for graphics cards...");
        List<GraphicsAdapterInfo> list = results = class_156.method_668() == class_156.class_158.field_1135 ? GraphicsAdapterProbe.findAdaptersLinux() : GraphicsAdapterProbe.findAdaptersCrossPlatform();
        if (results.isEmpty()) {
            LOGGER.warn("No graphics cards were found. Either you have no hardware devices supporting 3D acceleration, or something has gone terribly wrong!");
        }
        ADAPTERS = results;
    }

    public static List<GraphicsAdapterInfo> findAdaptersCrossPlatform() {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardwareInfo = systemInfo.getHardware();
        ArrayList<GraphicsAdapterInfo> results = new ArrayList<GraphicsAdapterInfo>();
        for (GraphicsCard graphicsCard : hardwareInfo.getGraphicsCards()) {
            GraphicsAdapterVendor vendor = GraphicsAdapterVendor.identifyVendorFromString(graphicsCard.getVendor());
            String name = graphicsCard.getName();
            String versionInfo = graphicsCard.getVersionInfo();
            GraphicsAdapterInfo info = new GraphicsAdapterInfo(vendor, name, versionInfo);
            results.add(info);
            LOGGER.info("Found graphics card: {}", (Object)info);
        }
        return results;
    }

    private static List<GraphicsAdapterInfo> findAdaptersLinux() {
        ArrayList<GraphicsAdapterInfo> results = new ArrayList<GraphicsAdapterInfo>();
        try (Stream<Path> devices = Files.list(Path.of("/sys/bus/pci/devices/", new String[0]));){
            Iterable devicesIter = devices::iterator;
            for (Path devicePath : devicesIter) {
                String deviceClass = Files.readString(devicePath.resolve("class")).trim();
                if (!deviceClass.equals("0x030000") && !deviceClass.equals("0x030200")) continue;
                String deviceVendor = Files.readString(devicePath.resolve("vendor")).trim();
                GraphicsAdapterVendor vendor = GraphicsAdapterVendor.identifyVendorFromString(deviceVendor);
                String deviceId = Files.readString(devicePath.resolve("device")).trim();
                String name = ExecutingCommand.runNative((String)("lspci -vmm -d " + deviceVendor.substring(2) + ":" + deviceId.substring(2))).stream().filter(line -> line.startsWith("Device:")).map(line -> line.substring("Device:".length()).trim()).findFirst().orElse("unknown");
                String versionInfo = "unknown";
                try {
                    versionInfo = Files.readString(devicePath.resolve("driver/module/version")).trim();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                GraphicsAdapterInfo info = new GraphicsAdapterInfo(vendor, name, versionInfo);
                results.add(info);
                LOGGER.info("Found graphics card: {}", (Object)info);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return results;
    }

    public static Collection<GraphicsAdapterInfo> getAdapters() {
        if (ADAPTERS == null) {
            throw new RuntimeException("Graphics adapters not probed yet");
        }
        return ADAPTERS;
    }
}

