/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter;

import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.PainterObject;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.unit.FixedNumberUnit;
import dev.latvian.mods.unit.Unit;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.jetbrains.annotations.Nullable;

public class PainterObjectStorage {
    private static final ScreenPainterObject[] NO_SCREEN_OBJECTS = new ScreenPainterObject[0];
    public final Painter painter;
    private final Map<String, PainterObject> objects = new LinkedHashMap<String, PainterObject>();

    public PainterObjectStorage(Painter p) {
        this.painter = p;
    }

    @Nullable
    public PainterObject getObject(String key) {
        return this.objects.get(key);
    }

    public Collection<PainterObject> getObjects() {
        return this.objects.isEmpty() ? List.of() : this.objects.values();
    }

    public void handle(class_2487 root) {
        class_2487 tag;
        if (root.method_10545("bulk")) {
            class_2499 bulk = root.method_10554("bulk", 10);
            for (int i = 0; i < bulk.size(); ++i) {
                this.handle(bulk.method_10602(i));
            }
            return;
        }
        Object i = root.method_10580("*");
        if (i instanceof class_2487) {
            tag = (class_2487)i;
            if (tag.method_10577("remove")) {
                this.objects.clear();
            } else {
                i = this.objects.values().iterator();
                while (i.hasNext()) {
                    PainterObject o = (PainterObject)i.next();
                    o.update(tag);
                }
            }
        }
        if ((i = root.method_10580("$")) instanceof class_2487) {
            tag = (class_2487)i;
            for (String k : tag.method_10541()) {
                if (tag.method_10573(k, 99)) {
                    this.painter.setVariable(k, (Unit)FixedNumberUnit.of((double)tag.method_10583(k)));
                    continue;
                }
                this.painter.setVariable(k, this.painter.unitOf(ConsoleJS.CLIENT, (Object)tag.method_10580(k)));
            }
        }
        for (String key : root.method_10541()) {
            if (key.equals("*") || key.equals("$")) continue;
            class_2487 tag2 = root.method_10562(key);
            PainterObject o = this.objects.get(key);
            if (o != null) {
                o.update(tag2);
                continue;
            }
            if (key.indexOf(32) != -1) {
                ConsoleJS.CLIENT.error("Painter id can't contain spaces!");
                continue;
            }
            String type = tag2.method_10558("type");
            PainterObject o1 = this.painter.make(type);
            if (o1 != null) {
                o1.id = key;
                o1.parent = this;
                o1.update(tag2);
                this.objects.put(key, o1);
                continue;
            }
            ConsoleJS.CLIENT.error("Unknown Painter type: " + type);
        }
    }

    public void clear() {
        this.objects.clear();
    }

    public ScreenPainterObject[] createScreenObjects() {
        return this.objects.isEmpty() ? NO_SCREEN_OBJECTS : (ScreenPainterObject[])this.objects.values().stream().filter(o -> o instanceof ScreenPainterObject).map(o -> (ScreenPainterObject)o).toArray(ScreenPainterObject[]::new);
    }

    public void remove(String id) {
        this.objects.remove(id);
    }
}

