/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.custom.BasicBlockJS;
import dev.latvian.mods.kubejs.client.ModelGenerator;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HorizontalDirectionalBlockBuilder
extends BlockBuilder {
    public HorizontalDirectionalBlockBuilder(class_2960 i) {
        super(i);
    }

    @Override
    protected void generateBlockStateJson(VariantBlockStateGenerator bs) {
        String modelLocation = this.model.isEmpty() ? this.newID("block/", "").toString() : this.model;
        bs.variant("facing=north", v -> v.model(modelLocation));
        bs.variant("facing=east", v -> v.model(modelLocation).y(90));
        bs.variant("facing=south", v -> v.model(modelLocation).y(180));
        bs.variant("facing=west", v -> v.model(modelLocation).y(270));
    }

    @Override
    protected void generateBlockModelJsons(AssetJsonGenerator gen) {
        gen.blockModel(this.id, mg -> {
            String side = this.getTextureOrDefault("side", this.newID("block/", "").toString());
            mg.texture("side", side);
            mg.texture("front", this.getTextureOrDefault("front", this.newID("block/", "_front").toString()));
            mg.texture("particle", this.getTextureOrDefault("particle", side));
            mg.texture("top", this.getTextureOrDefault("top", side));
            if (this.textures.has("bottom")) {
                mg.parent("block/orientable_with_bottom");
                mg.texture("bottom", this.textures.get("bottom").getAsString());
            } else {
                mg.parent("minecraft:block/orientable");
            }
        });
    }

    @Override
    protected void generateItemModelJson(ModelGenerator m) {
        m.parent(this.model.isEmpty() ? this.newID("block/", "").toString() : this.model);
    }

    @Override
    public HorizontalDirectionalBlockBuilder textureAll(String tex) {
        super.textureAll(tex);
        this.texture("side", tex);
        return this;
    }

    private String getTextureOrDefault(String name, String defaultTexture) {
        return this.textures.has(name) ? this.textures.get(name).getAsString() : defaultTexture;
    }

    @Override
    public class_2248 createObject() {
        return this.blockEntityInfo != null ? new WithEntity(this) : new HorizontalDirectionalBlockJS(this);
    }

    public static class WithEntity
    extends HorizontalDirectionalBlockJS
    implements class_2343 {
        public WithEntity(BlockBuilder p) {
            super(p);
        }

        @Nullable
        public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
            return this.blockBuilder.blockEntityInfo.createBlockEntity(blockPos, blockState);
        }

        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
            return this.blockBuilder.blockEntityInfo.getTicker(level);
        }
    }

    public static class HorizontalDirectionalBlockJS
    extends BasicBlockJS {
        public static final class_2753 FACING = class_2741.field_12481;
        public final Map<class_2350, class_265> shapes = new HashMap<class_2350, class_265>();

        public HorizontalDirectionalBlockJS(BlockBuilder p) {
            super(p);
            if (this.hasCustomShape()) {
                class_2350.class_2353.field_11062.forEach(direction -> this.shapes.put((class_2350)direction, HorizontalDirectionalBlockJS.rotateShape(this.shape, direction)));
            }
        }

        private static class_265 rotateShape(class_265 shape, class_2350 direction) {
            ArrayList<class_238> newShapes = new ArrayList<class_238>();
            switch (direction) {
                case field_11043: {
                    return shape;
                }
                case field_11035: {
                    shape.method_1089((x1, y1, z1, x2, y2, z2) -> newShapes.add(new class_238(1.0 - x2, y1, 1.0 - z2, 1.0 - x1, y2, 1.0 - z1)));
                    break;
                }
                case field_11039: {
                    shape.method_1089((x1, y1, z1, x2, y2, z2) -> newShapes.add(new class_238(z1, y1, 1.0 - x2, z2, y2, 1.0 - x1)));
                    break;
                }
                case field_11034: {
                    shape.method_1089((x1, y1, z1, x2, y2, z2) -> newShapes.add(new class_238(1.0 - z2, y1, x1, 1.0 - z1, y2, x2)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot rotate around direction " + direction.method_10151());
                }
            }
            return BlockBuilder.createShape(newShapes);
        }

        @Override
        protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
            builder.method_11667(new class_2769[]{FACING});
            super.method_9515(builder);
        }

        @Override
        public class_2680 method_9605(@NotNull class_1750 context) {
            class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
            if (this.blockBuilder.canBeWaterlogged()) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910));
            }
            return state;
        }

        private boolean hasCustomShape() {
            return this.shape != class_259.method_1077();
        }

        @Override
        @Deprecated
        public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
            return this.hasCustomShape() ? this.shapes.get(state.method_11654((class_2769)FACING)) : this.shape;
        }
    }
}

