/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.architectury.utils.value.IntValue;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.player.PlayerEventJS;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

@Info(value="Invoked when a block is destroyed by a player.\n")
public class BlockBrokenEventJS
extends PlayerEventJS {
    private final class_3222 entity;
    private final class_1937 level;
    private final class_2338 pos;
    private final class_2680 state;
    @Nullable
    private final IntValue xp;

    public BlockBrokenEventJS(class_3222 entity, class_1937 level, class_2338 pos, class_2680 state, @Nullable IntValue xp) {
        this.entity = entity;
        this.level = level;
        this.pos = pos;
        this.state = state;
        this.xp = xp;
    }

    @Info(value="The player that broke the block.")
    public class_3222 getEntity() {
        return this.entity;
    }

    @Info(value="The block that was broken.")
    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.level, this.pos){

            @Override
            public class_2680 getBlockState() {
                return BlockBrokenEventJS.this.state;
            }
        };
    }

    @Info(value="The experience dropped by the block. Always `0` on Fabric.")
    public int getXp() {
        if (this.xp == null) {
            return 0;
        }
        return this.xp.getAsInt();
    }

    @Info(value="Sets the experience dropped by the block. Only works on Forge.")
    public void setXp(int xp) {
        if (this.xp != null) {
            this.xp.accept(xp);
        }
    }
}

