/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.ingredient.IngredientWithCustomPredicate;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientActionCallback;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

@Info(value="Various Ingredient related helper methods")
public interface IngredientWrapper {
    @Info(value="A completely empty ingredient that will only match air")
    public static final class_1856 none = class_1856.field_9017;
    @Info(value="An ingredient that matches everything")
    public static final class_1856 all = IngredientPlatformHelper.get().wildcard();

    @Info(value="Returns an ingredient of the input")
    public static class_1856 of(class_1856 ingredient) {
        return ingredient;
    }

    @Info(value="Returns an ingredient of the input, with the specified count")
    public static InputItem of(class_1856 ingredient, int count) {
        return ingredient.kjs$withCount(count);
    }

    @Info(value="Make a custom ingredient where items must match both the parent ingredient and the custom predicate function")
    public static class_1856 custom(class_1856 parent, Predicate<class_1799> predicate) {
        if (RecipesEventJS.customIngredientMap != null) {
            IngredientWithCustomPredicate ingredient = new IngredientWithCustomPredicate(parent, UUID.randomUUID(), predicate);
            RecipesEventJS.customIngredientMap.put(ingredient.uuid, ingredient);
            return IngredientPlatformHelper.get().custom(parent, ingredient.uuid);
        }
        return IngredientPlatformHelper.get().custom(parent, predicate);
    }

    @Info(value="Make a custom ingredient where a match must match the provided predicate function")
    public static class_1856 custom(Predicate<class_1799> predicate) {
        return IngredientWrapper.custom(all, predicate);
    }

    @Info(value="Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function")
    public static class_1856 customNBT(class_1856 in, Predicate<class_2487> predicate) {
        return IngredientWrapper.custom(in, is -> is.method_7985() && predicate.test(is.method_7969()));
    }

    @Info(value="Register a custom ingredient action for use in recipes with Recipe#customIngredientAction")
    public static void registerCustomIngredientAction(String id, CustomIngredientActionCallback callback) {
        CustomIngredientAction.MAP.put(id, callback);
    }

    @Info(value="Checks if the passed in object is an Ingredient.\nNote that this does not mean it will not function as an Ingredient if passed to something that requests one.\n")
    public static boolean isIngredient(@Nullable Object o) {
        return o instanceof class_1856;
    }
}

