/*
 * Decompiled with CFR 0.152.
 */
package ru.aiefu.timeandwindct;

import com.mojang.brigadier.CommandDispatcher;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.aiefu.timeandwindct.ConfigurationManager;
import ru.aiefu.timeandwindct.NetworkPacketsID;
import ru.aiefu.timeandwindct.TAWCommands;
import ru.aiefu.timeandwindct.config.ModConfig;
import ru.aiefu.timeandwindct.config.SystemTimeConfig;
import ru.aiefu.timeandwindct.config.TimeDataStorage;

public class TimeAndWindCT
implements ModInitializer {
    public static final String MOD_ID = "tawct";
    public static final Logger LOGGER = LogManager.getLogger();
    public static HashMap<String, TimeDataStorage> timeDataMap;
    public static HashMap<String, SystemTimeConfig> sysTimeMap;
    public static ModConfig CONFIG;
    public static SystemTimeConfig systemTimeConfig;
    public static boolean debugMode;

    public void onInitialize() {
        this.craftPaths();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ConfigurationManager.readTimeData();
            systemTimeConfig = ConfigurationManager.readGlobalSysTimeCfg();
            sysTimeMap = ConfigurationManager.readSysTimeCfg();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (TimeAndWindCT.CONFIG.syncWithSystemTime) {
                ((class_1928.class_4310)server.method_3767().method_20746(class_1928.field_20637)).method_20758(false, server);
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, ra, env) -> TAWCommands.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    public void craftPaths() {
        File file = new File("./config/time-and-wind");
        file.mkdirs();
        if (!Files.exists(Paths.get("./config/time-and-wind/time-data.json", new String[0]), new LinkOption[0])) {
            ConfigurationManager.genTimeData();
        }
        if (!Files.exists(Paths.get("./config/time-and-wind/config.json", new String[0]), new LinkOption[0])) {
            ConfigurationManager.generateModConfig();
        }
        if (!Files.exists(Paths.get("./config/time-and-wind/system-time-data-global.json", new String[0]), new LinkOption[0])) {
            ConfigurationManager.generateSysTimeCfg();
        }
        if (!Files.exists(Paths.get("./config/time-and-wind/system-time-data.json", new String[0]), new LinkOption[0])) {
            ConfigurationManager.generateMapSysTime();
        }
        CONFIG = ConfigurationManager.readModConfig();
    }

    public static String getFormattedTime(long ms) {
        long seconds = ms;
        long hours = seconds / 3600L;
        long minutes = (seconds -= hours * 3600L) / 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds -= minutes * 60L);
    }

    public static void sendConfigSyncPacket(class_3222 player) {
        if (!Objects.requireNonNull(player.method_5682()).method_19466(player.method_7334())) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            String cfgJson = ConfigurationManager.gson_pretty.toJson((Object)CONFIG);
            String cfgsJson = ConfigurationManager.gson_pretty.toJson((Object)systemTimeConfig);
            buf.method_10814(cfgJson);
            buf.method_10814(cfgsJson);
            buf.method_34063(timeDataMap, class_2540::method_10814, (packetByteBuf, timeDataStorage) -> {
                packetByteBuf.writeInt(timeDataStorage.dayDuration);
                packetByteBuf.writeInt(timeDataStorage.nightDuration);
            });
            buf.method_34063(sysTimeMap, class_2540::method_10814, (packetByteBuf, systemTimeConfig1) -> {
                packetByteBuf.method_10814(systemTimeConfig1.sunrise);
                packetByteBuf.method_10814(systemTimeConfig1.sunset);
                packetByteBuf.method_10814(systemTimeConfig1.timeZone);
            });
            ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkPacketsID.SYNC_CONFIG, (class_2540)buf);
            LOGGER.info("[Time & Wind] Sending config to player");
        } else {
            ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkPacketsID.SETUP_TIME, (class_2540)new class_2540(Unpooled.buffer()));
        }
    }

    static {
        debugMode = false;
    }
}

