/*
 * Decompiled with CFR 0.152.
 */
package ru.aiefu.timeandwindct;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import ru.aiefu.timeandwindct.ConfigurationManager;
import ru.aiefu.timeandwindct.ITimeOperations;
import ru.aiefu.timeandwindct.NetworkPacketsID;
import ru.aiefu.timeandwindct.TimeAndWindCT;
import ru.aiefu.timeandwindct.config.ModConfig;
import ru.aiefu.timeandwindct.config.TimeDataStorage;
import ru.aiefu.timeandwindct.tickers.DefaultTicker;
import ru.aiefu.timeandwindct.tickers.SystemTimeTicker;
import ru.aiefu.timeandwindct.tickers.Ticker;
import ru.aiefu.timeandwindct.tickers.TimeTicker;

public class TAWCommands {
    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"reload").executes(context -> TAWCommands.reloadCfg((class_2168)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"enable-debug").then(class_2170.method_9244((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(context -> TAWCommands.enableDebug((class_2168)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"boolean"))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"set-cycle-length").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"day_length", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"night_length", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TAWCommands.setTimeLength(class_2181.method_9289((CommandContext)context, (String)"dimension"), (class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"day_length"), IntegerArgumentType.getInteger((CommandContext)context, (String)"night_length"))))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"remove-cycle-entry").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> TAWCommands.removeConfigEntry((class_2168)context.getSource(), class_2181.method_9289((CommandContext)context, (String)"dimension"))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"switch-system-time-sync").then(class_2170.method_9244((String)"ssyncstate", (ArgumentType)BoolArgumentType.bool()).executes(context -> TAWCommands.switchSystemTimeSyncState((class_2168)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"ssyncstate"))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"switch-sys-time-per-dimension").then(class_2170.method_9244((String)"per-dim-state", (ArgumentType)BoolArgumentType.bool()).executes(context -> TAWCommands.switchSystemTimePerDim((class_2168)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"per-dim-state"))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"set-system-time-properties").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"sunrise", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"sunset", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"timezone", (ArgumentType)StringArgumentType.string()).executes(context -> TAWCommands.setSysSyncTimeProperties(class_2181.method_9289((CommandContext)context, (String)"dimension"), (class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"sunrise"), StringArgumentType.getString((CommandContext)context, (String)"sunset"), StringArgumentType.getString((CommandContext)context, (String)"timezone")))))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"set-global-sys-time-properties").then(class_2170.method_9244((String)"sunrise", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"sunset", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"timezone", (ArgumentType)StringArgumentType.string()).executes(context -> TAWCommands.setGlobalSysTimeProps((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"sunrise"), StringArgumentType.getString((CommandContext)context, (String)"sunset"), StringArgumentType.getString((CommandContext)context, (String)"timezone"))))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"get-current-world-id").executes(context -> TAWCommands.printCurrentWorldId((class_2168)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"parse-worlds-ids").executes(context -> TAWCommands.parseWorldsIds((class_2168)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"get-ambient-darkness").executes(context -> TAWCommands.printAmbientDarkness((class_2168)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"get-light-level").executes(context -> TAWCommands.getLightLevel((class_2168)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"get-time-data").executes(context -> TAWCommands.getTimeConfig((class_2168)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"time-ticker-values").executes(context -> TAWCommands.getTimeChecker((class_2168)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taw").then(class_2170.method_9247((String)"system-time").executes(context -> TAWCommands.getSystemTime((class_2168)context.getSource()))));
    }

    private static int enableDebug(class_2168 source, boolean bl) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            TimeAndWindCT.debugMode = bl;
            source.method_9226(() -> class_2561.method_43470((String)("[Time & Wind] Set debug mod to " + bl)), true);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        }
        return 0;
    }

    private static int setTimeLength(class_3218 targetWorld, class_2168 source, int dayD, int nightD) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            String worldId = targetWorld.method_27983().method_29177().toString();
            ConfigurationManager.updateTimeData(worldId, dayD, nightD);
            source.method_9226(() -> class_2561.method_43470((String)"Configuration entry added, now use /taw reload to apply changes"), false);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        }
        return 0;
    }

    private static int setSysSyncTimeProperties(class_3218 targetDimension, class_2168 source, String sunrise, String sunset, String timeZone) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            String worldId = targetDimension.method_27983().method_29177().toString();
            if (TAWCommands.checkFormat(sunrise) && TAWCommands.checkFormat(sunset) && TAWCommands.checkFormat(timeZone)) {
                ConfigurationManager.updateMapSysTime(worldId, sunrise, sunset, timeZone);
                source.method_9226(() -> class_2561.method_43470((String)"Configuration entry added, now use /taw reload to apply changes"), false);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"Error, sunrise, sunset or timezone param contains non numeric symbols"));
            }
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        return 0;
    }

    private static int setGlobalSysTimeProps(class_2168 source, String sunrise, String sunset, String timezone) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            if (TAWCommands.checkFormat(sunrise) && TAWCommands.checkFormat(sunset) && TAWCommands.checkFormat(timezone)) {
                ConfigurationManager.updateGlobalSysTimeCfg(sunrise, sunset, timezone);
                source.method_9226(() -> class_2561.method_43470((String)"Configuration entry added, now use /taw reload to apply changes"), false);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"Error, sunrise, sunset or timezone param contains non numeric symbols"));
            }
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        return 0;
    }

    private static boolean checkFormat(String time) {
        int k = time.indexOf(":");
        if (k == -1) {
            return false;
        }
        String hour = time.substring(0, k);
        String min = time.substring(k + 1);
        return hour.matches("[0-9]+") && min.matches("[0-9]+");
    }

    private static int removeConfigEntry(class_2168 source, class_3218 targetWorld) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            String worldId = targetWorld.method_27983().method_29177().toString();
            if (TimeAndWindCT.timeDataMap.containsKey(worldId)) {
                TimeAndWindCT.timeDataMap.remove(worldId);
                ConfigurationManager.updateTimeData();
                source.method_9226(() -> class_2561.method_43470((String)"Entry removed, now use /taw reload to apply changes"), false);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)("Config does not contains settings for " + worldId)));
            }
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        }
        return 0;
    }

    private static int switchSystemTimeSyncState(class_2168 source, boolean state) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            ((class_1928.class_4310)source.method_9211().method_3767().method_20746(class_1928.field_20637)).method_20758(!state, source.method_9211());
            ModConfig cfg = TimeAndWindCT.CONFIG.copy();
            cfg.syncWithSystemTime = state;
            ConfigurationManager.updateModConfig(cfg);
            source.method_9226(() -> class_2561.method_43470((String)("SysTimeSync state switched to" + state + " now use /taw reload to apply changes")), false);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        }
        return 0;
    }

    private static int switchSystemTimePerDim(class_2168 source, boolean state) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            ModConfig cfg = TimeAndWindCT.CONFIG.copy();
            cfg.syncWithSystemTime = state;
            ConfigurationManager.updateModConfig(cfg);
            source.method_9226(() -> class_2561.method_43470((String)("SystemTimePerDimension state switched to" + state + " now use /taw reload to apply changes")), false);
        }
        return 0;
    }

    private static int reloadCfg(class_2168 source) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            MinecraftServer server = source.method_9211();
            int result = ConfigurationManager.readTimeData();
            TimeAndWindCT.CONFIG = ConfigurationManager.readModConfig();
            TimeAndWindCT.systemTimeConfig = ConfigurationManager.readGlobalSysTimeCfg();
            TimeAndWindCT.sysTimeMap = ConfigurationManager.readSysTimeCfg();
            if (result == 0) {
                source.method_9226(() -> class_2561.method_43470((String)"Unable to reload config"), false);
                return 0;
            }
            for (class_3218 serverWorld : source.method_9211().method_3738()) {
                String id = serverWorld.method_27983().method_29177().toString();
                if (TimeAndWindCT.CONFIG.syncWithSystemTime) {
                    if (TimeAndWindCT.CONFIG.systemTimePerDimensions && TimeAndWindCT.sysTimeMap.containsKey(id)) {
                        ((ITimeOperations)serverWorld).time_and_wind_custom_ticker$setTimeTicker(new SystemTimeTicker((ITimeOperations)serverWorld, TimeAndWindCT.sysTimeMap.get(id)));
                        continue;
                    }
                    ((ITimeOperations)serverWorld).time_and_wind_custom_ticker$setTimeTicker(new SystemTimeTicker((ITimeOperations)serverWorld, TimeAndWindCT.systemTimeConfig));
                    continue;
                }
                if (TimeAndWindCT.timeDataMap.containsKey(id)) {
                    TimeDataStorage storage = TimeAndWindCT.timeDataMap.get(id);
                    ((ITimeOperations)serverWorld).time_and_wind_custom_ticker$setTimeTicker(new TimeTicker(storage.dayDuration, storage.nightDuration, (class_1937)serverWorld));
                    continue;
                }
                ((ITimeOperations)serverWorld).time_and_wind_custom_ticker$setTimeTicker(new DefaultTicker());
            }
            for (class_3222 player : server.method_3760().method_14571()) {
                TimeAndWindCT.sendConfigSyncPacket(player);
            }
            source.method_9226(() -> class_2561.method_43470((String)"[Time & Wind] Config reloaded"), true);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        }
        return 0;
    }

    private static int printCurrentWorldId(class_2168 source) throws CommandSyntaxException {
        if (TimeAndWindCT.debugMode || source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            String id = source.method_9207().method_37908().method_27983().method_29177().toString();
            source.method_9226(() -> class_2561.method_43470((String)id), false);
            ServerPlayNetworking.send((class_3222)source.method_9207(), (class_2960)NetworkPacketsID.WORLD_ID_CLIPBOARD, (class_2540)new class_2540(Unpooled.buffer()).method_10814(id));
        }
        return 0;
    }

    private static int printAmbientDarkness(class_2168 source) throws CommandSyntaxException {
        if (TimeAndWindCT.debugMode || source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            class_3222 player = source.method_9207();
            source.method_9226(() -> class_2561.method_43470((String)("Ambient Darkness: " + player.method_37908().method_8594())), false);
        }
        return 0;
    }

    private static int parseWorldsIds(class_2168 source) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            ArrayList ids = new ArrayList();
            source.method_9211().method_3738().forEach(serverWorld -> ids.add(serverWorld.method_27983().method_29177().toString()));
            try (FileWriter writer = ConfigurationManager.getFileWriter("./taw-worlds-ids.json");){
                ConfigurationManager.gson_pretty.toJson(ids, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            source.method_9226(() -> class_2561.method_43470((String)"Saved to minecraft root folder"), false);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        }
        return 0;
    }

    private static int getLightLevel(class_2168 source) throws CommandSyntaxException {
        if (TimeAndWindCT.debugMode || source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            class_3222 player = source.method_9207();
            source.method_9226(() -> class_2561.method_43470((String)("Light Level: " + player.method_37908().method_22339(player.method_24515()))), false);
        }
        return 0;
    }

    private static int getTimeConfig(class_2168 source) throws CommandSyntaxException {
        if (TimeAndWindCT.debugMode || source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            class_3222 player = source.method_9207();
            String worldId = player.method_37908().method_27983().method_29177().toString();
            if (player.method_37908().method_8597().method_29960()) {
                source.method_9226(() -> class_2561.method_43470((String)"Current dimension have fixed time, custom configuration is useless"), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"Current dimension does not have fixed time, custom configuration should work fine"), false);
            }
            if (TimeAndWindCT.timeDataMap.containsKey(worldId)) {
                TimeDataStorage storage = TimeAndWindCT.timeDataMap.get(worldId);
                source.method_9226(() -> class_2561.method_43470((String)("Server config for current world: Day Duration: " + storage.dayDuration + " Night Duration: " + storage.nightDuration)), true);
                ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkPacketsID.CFG_DEBUG_INFO, (class_2540)new class_2540(Unpooled.buffer()));
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"No Data found for current world on server side"));
            }
        }
        return 0;
    }

    private static int getTimeChecker(class_2168 source) throws CommandSyntaxException {
        if (TimeAndWindCT.debugMode || source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            Ticker t = ((ITimeOperations)source.method_9225()).time_and_wind_custom_ticker$getTimeTicker();
            if (t instanceof TimeTicker) {
                TimeTicker ticker = (TimeTicker)t;
                source.method_9226(() -> class_2561.method_43470((String)("Day: " + ticker.getDayD() + " Night: " + ticker.getNightD())), false);
                source.method_9226(() -> class_2561.method_43470((String)("Day Mod: " + ticker.getDayMod() + " Night Mod: " + ticker.getNightMod())), false);
                source.method_9226(() -> class_2561.method_43470((String)("Day RE: " + ticker.getDayRoundingError() + " Night RE: " + ticker.getNightRoundingError())), false);
            } else if (t instanceof SystemTimeTicker) {
                SystemTimeTicker stt = (SystemTimeTicker)t;
                String sunrise = TimeAndWindCT.getFormattedTime(stt.getSunrise() / 1000);
                String sunset = TimeAndWindCT.getFormattedTime(stt.getSunset() / 1000);
                String dayD = TimeAndWindCT.getFormattedTime(stt.getDayD() / 1000L);
                String nightD = TimeAndWindCT.getFormattedTime(stt.getNightD() / 1000L);
                source.method_9226(() -> class_2561.method_43470((String)"Time is synced with system time"), false);
                source.method_9226(() -> class_2561.method_43470((String)("Sunrise are at: " + sunrise + " and sunset are at: " + sunset + " in timezone: " + TimeAndWindCT.systemTimeConfig.timeZone)), false);
                source.method_9226(() -> class_2561.method_43470((String)("Day Length are: " + dayD + " and Night Length are: " + nightD)), false);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"This world uses default time ticker"));
            }
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        }
        return 0;
    }

    private static int getSystemTime(class_2168 source) throws CommandSyntaxException {
        if (source.method_9259(4) || source.method_9211().method_19466(source.method_9207().method_7334())) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            LocalDateTime time = LocalDateTime.now();
            source.method_9226(() -> class_2561.method_43470((String)time.format(formatter)), false);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"[Time & Wind] Permission level of 4 is required to run this command"));
        }
        return 0;
    }
}

