/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.config.MunitionProperties;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesSerializer;
import rbasamoyai.createbigcannons.munitions.config.PropertiesMunitionEntity;
import rbasamoyai.createbigcannons.network.RootPacket;

public class MunitionPropertiesHandler {
    private static final Map<class_1299<?>, MunitionPropertiesSerializer<?>> ENTITY_TYPE_SERIALIZERS = new Reference2ReferenceOpenHashMap();
    private static final Map<class_1299<?>, MunitionProperties> PROJECTILES = new Reference2ObjectOpenHashMap();
    private static final Map<class_2248, MunitionPropertiesSerializer<?>> BLOCK_SERIALIZERS = new Reference2ReferenceOpenHashMap();
    private static final Map<class_2248, MunitionProperties> BLOCK_PROPELLANT = new Reference2ObjectOpenHashMap();
    private static final Map<class_1792, MunitionPropertiesSerializer<?>> ITEM_SERIALIZERS = new Reference2ReferenceOpenHashMap();
    private static final Map<class_1792, MunitionProperties> ITEM_PROPELLANT = new Reference2ObjectOpenHashMap();

    public static <T extends MunitionProperties> void registerPropertiesSerializer(class_1299<? extends PropertiesMunitionEntity<T>> type, MunitionPropertiesSerializer<T> ser) {
        if (ENTITY_TYPE_SERIALIZERS.containsKey(type)) {
            throw new IllegalStateException("Serializer for entity type " + class_7923.field_41177.method_10221(type) + " already registered");
        }
        ENTITY_TYPE_SERIALIZERS.put(type, ser);
    }

    public static <T extends MunitionProperties, B extends class_2248> void registerPropertiesSerializer(B block, MunitionPropertiesSerializer<T> ser) {
        if (BLOCK_SERIALIZERS.containsKey(block)) {
            throw new IllegalStateException("Serializer for block " + class_7923.field_41175.method_10221(block) + " already registered");
        }
        BLOCK_SERIALIZERS.put(block, ser);
    }

    public static <T extends MunitionProperties, I extends class_1792> void registerPropertiesSerializer(I item, MunitionPropertiesSerializer<T> ser) {
        if (ITEM_SERIALIZERS.containsKey(item)) {
            throw new IllegalStateException("Serializer for item " + class_7923.field_41178.method_10221(item) + " already registered");
        }
        ITEM_SERIALIZERS.put(item, ser);
    }

    @Nullable
    public static MunitionProperties getProperties(class_1299<?> type) {
        return PROJECTILES.get(type);
    }

    @Nullable
    public static MunitionProperties getProperties(class_1297 entity) {
        return MunitionPropertiesHandler.getProperties(entity.method_5864());
    }

    @Nullable
    public static MunitionProperties getProperties(class_2248 block) {
        return BLOCK_PROPELLANT.get(block);
    }

    @Nullable
    public static MunitionProperties getProperties(class_2680 state) {
        return MunitionPropertiesHandler.getProperties(state.method_26204());
    }

    @Nullable
    public static MunitionProperties getProperties(class_1792 item) {
        return ITEM_PROPELLANT.get(item);
    }

    @Nullable
    public static MunitionProperties getProperties(class_1799 stack) {
        return MunitionPropertiesHandler.getProperties(stack.method_7909());
    }

    public static void writeBuf(class_2540 buf) {
        buf.method_10804(PROJECTILES.size());
        for (Map.Entry<class_1299<?>, MunitionProperties> entry : PROJECTILES.entrySet()) {
            MunitionPropertiesHandler.toNetworkCasted(buf, entry.getKey(), entry.getValue());
        }
        buf.method_10804(BLOCK_PROPELLANT.size());
        for (Map.Entry<class_1299<?>, MunitionProperties> entry : BLOCK_PROPELLANT.entrySet()) {
            MunitionPropertiesHandler.toNetworkCasted(buf, (class_2248)entry.getKey(), entry.getValue());
        }
        buf.method_10804(ITEM_PROPELLANT.size());
        for (Map.Entry<class_1299<?>, MunitionProperties> entry : ITEM_PROPELLANT.entrySet()) {
            MunitionPropertiesHandler.toNetworkCasted(buf, (class_1792)entry.getKey(), entry.getValue());
        }
    }

    private static <T extends MunitionProperties> void toNetworkCasted(class_2540 buf, class_1299<?> type, T properties) {
        buf.method_10812(class_7923.field_41177.method_10221(type));
        MunitionPropertiesSerializer<?> ser = ENTITY_TYPE_SERIALIZERS.get(type);
        ser.toNetwork(buf, properties);
    }

    private static <T extends MunitionProperties> void toNetworkCasted(class_2540 buf, class_2248 block, T properties) {
        buf.method_10812(class_7923.field_41175.method_10221((Object)block));
        MunitionPropertiesSerializer<?> ser = BLOCK_SERIALIZERS.get(block);
        ser.toNetwork(buf, properties);
    }

    private static <T extends MunitionProperties> void toNetworkCasted(class_2540 buf, class_1792 item, T properties) {
        buf.method_10812(class_7923.field_41178.method_10221((Object)item));
        MunitionPropertiesSerializer<?> ser = ITEM_SERIALIZERS.get(item);
        ser.toNetwork(buf, properties);
    }

    public static void readBuf(class_2540 buf) {
        PROJECTILES.clear();
        int szProj = buf.method_10816();
        for (int i = 0; i < szProj; ++i) {
            class_2960 loc = buf.method_10810();
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(loc);
            MunitionPropertiesSerializer<?> ser = ENTITY_TYPE_SERIALIZERS.get(type);
            PROJECTILES.put((class_1299<?>)type, (MunitionProperties)ser.fromNetwork(loc, buf));
        }
        BLOCK_PROPELLANT.clear();
        int szBlock = buf.method_10816();
        for (int i = 0; i < szBlock; ++i) {
            class_2960 loc = buf.method_10810();
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(loc);
            MunitionPropertiesSerializer<?> ser = BLOCK_SERIALIZERS.get(block);
            BLOCK_PROPELLANT.put(block, (MunitionProperties)ser.fromNetwork(loc, buf));
        }
        ITEM_PROPELLANT.clear();
        int szItem = buf.method_10816();
        for (int i = 0; i < szItem; ++i) {
            class_2960 loc = buf.method_10810();
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(loc);
            MunitionPropertiesSerializer<?> ser = ITEM_SERIALIZERS.get(item);
            ITEM_PROPELLANT.put(item, (MunitionProperties)ser.fromNetwork(loc, buf));
        }
    }

    public static void syncTo(class_3222 player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundMunitionPropertiesPacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundMunitionPropertiesPacket(), server);
    }

    public record ClientboundMunitionPropertiesPacket(@Nullable class_2540 buf) implements RootPacket
    {
        public ClientboundMunitionPropertiesPacket() {
            this(null);
        }

        public static ClientboundMunitionPropertiesPacket copyOf(class_2540 buf) {
            return new ClientboundMunitionPropertiesPacket(new class_2540(buf.copy()));
        }

        @Override
        public void rootEncode(class_2540 buf) {
            MunitionPropertiesHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, class_2547 listener, @Nullable class_3222 sender) {
            if (this.buf != null) {
                MunitionPropertiesHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListenerItemPropellant
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListenerItemPropellant INSTANCE = new ReloadListenerItemPropellant();

        protected ReloadListenerItemPropellant() {
            super(GSON, "munition_properties/item_propellant");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
            ITEM_PROPELLANT.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    class_1792 item = (class_1792)class_7923.field_41178.method_17966(loc).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + loc + "'"));
                    MunitionPropertiesSerializer<?> ser = ITEM_SERIALIZERS.get(item);
                    if (ser == null) {
                        throw new JsonSyntaxException("No configuration for item '" + loc + "' present");
                    }
                    Object properties = ser.fromJson(loc, element.getAsJsonObject());
                    ITEM_PROPELLANT.put(item, (MunitionProperties)properties);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class ReloadListenerBlockPropellant
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListenerBlockPropellant INSTANCE = new ReloadListenerBlockPropellant();

        protected ReloadListenerBlockPropellant() {
            super(GSON, "munition_properties/block_propellant");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
            BLOCK_PROPELLANT.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    class_2248 block = (class_2248)class_7923.field_41175.method_17966(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                    MunitionPropertiesSerializer<?> ser = BLOCK_SERIALIZERS.get(block);
                    if (ser == null) {
                        throw new JsonSyntaxException("No configuration for block '" + loc + "' present");
                    }
                    Object properties = ser.fromJson(loc, element.getAsJsonObject());
                    BLOCK_PROPELLANT.put(block, (MunitionProperties)properties);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class ReloadListenerProjectiles
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListenerProjectiles INSTANCE = new ReloadListenerProjectiles();

        protected ReloadListenerProjectiles() {
            super(GSON, "munition_properties/projectiles");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
            PROJECTILES.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    class_1299 type = (class_1299)class_7923.field_41177.method_17966(loc).orElseThrow(() -> new JsonSyntaxException("Unknown entity type '" + loc + "'"));
                    MunitionPropertiesSerializer<?> ser = ENTITY_TYPE_SERIALIZERS.get(type);
                    if (ser == null) {
                        throw new JsonSyntaxException("No configuration for entity type '" + loc + "' present");
                    }
                    Object properties = ser.fromJson(loc, element.getAsJsonObject());
                    PROJECTILES.put((class_1299<?>)type, (MunitionProperties)properties);
                }
                catch (Exception exception) {}
            }
        }
    }
}

