/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedBigCannonProjectileProperties;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesSerializer;

public class FluidShellProperties
extends FuzedBigCannonProjectileProperties {
    private final int fluidShellCapacity;
    private final int mBPerFluidBlob;
    private final int mBPerAoeRadius;
    private final float fluidBlobSpread;

    public FluidShellProperties(float entityDamage, float durabilityMass, boolean rendersInvulnerable, boolean ignoresEntityArmor, double gravity, double drag, float knockback, int addedChargePower, float minimumChargePower, boolean canSquib, float addedRecoil, boolean baseFuze, int fluidShellCapacity, int mBPerFluidBlob, int mBPerAoeRadius, float fluidBlobSpread) {
        super(entityDamage, durabilityMass, rendersInvulnerable, ignoresEntityArmor, gravity, drag, knockback, addedChargePower, minimumChargePower, canSquib, addedRecoil, baseFuze);
        this.fluidShellCapacity = fluidShellCapacity;
        this.mBPerFluidBlob = mBPerFluidBlob;
        this.mBPerAoeRadius = mBPerAoeRadius;
        this.fluidBlobSpread = fluidBlobSpread;
    }

    public FluidShellProperties(String id, JsonObject obj) {
        super(id, obj);
        this.fluidShellCapacity = Math.max(1, MunitionPropertiesSerializer.getOrWarn(obj, "fluid_shell_capacity", id, 2000, JsonElement::getAsInt));
        this.mBPerFluidBlob = Math.max(25, MunitionPropertiesSerializer.getOrWarn(obj, "millibuckets_per_fluid_blob", id, 250, JsonElement::getAsInt));
        this.mBPerAoeRadius = Math.max(25, MunitionPropertiesSerializer.getOrWarn(obj, "millibuckets_per_area_of_effect_radius", id, 50, JsonElement::getAsInt));
        this.fluidBlobSpread = Math.max(0.01f, MunitionPropertiesSerializer.getOrWarn(obj, "fluid_blob_spread", id, Float.valueOf(1.0f), JsonElement::getAsFloat).floatValue());
    }

    public FluidShellProperties(class_2540 buf) {
        super(buf);
        this.fluidShellCapacity = buf.method_10816();
        this.mBPerFluidBlob = buf.method_10816();
        this.mBPerAoeRadius = buf.method_10816();
        this.fluidBlobSpread = buf.readFloat();
    }

    @Override
    public void toNetwork(class_2540 buf) {
        super.toNetwork(buf);
        buf.method_10804(this.fluidShellCapacity).method_10804(this.mBPerFluidBlob).method_10804(this.mBPerAoeRadius).writeFloat(this.fluidBlobSpread);
    }

    public int fluidShellCapacity() {
        return this.fluidShellCapacity;
    }

    public int mBPerFluidBlob() {
        return this.mBPerFluidBlob;
    }

    public int mBPerAoeRadius() {
        return this.mBPerAoeRadius;
    }

    public float fluidBlobSpread() {
        return this.fluidBlobSpread;
    }

    public static class Serializer
    implements MunitionPropertiesSerializer<FluidShellProperties> {
        @Override
        public FluidShellProperties fromJson(class_2960 loc, JsonObject obj) {
            return new FluidShellProperties(loc.toString(), obj);
        }

        @Override
        public FluidShellProperties fromNetwork(class_2960 loc, class_2540 buf) {
            return new FluidShellProperties(buf);
        }
    }
}

