/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;

public class FluidCastingTimeHandler {
    public static final Map<class_6862<class_3611>, Integer> TAGS_TO_LOAD = new Object2ObjectLinkedOpenHashMap();
    public static final Map<class_3611, Integer> FLUID_MAP = new Reference2ObjectOpenHashMap();
    public static final Map<class_3611, Integer> TAG_MAP = new Reference2ObjectOpenHashMap();

    public static void clear() {
        FLUID_MAP.clear();
        TAG_MAP.clear();
        TAGS_TO_LOAD.clear();
    }

    public static void loadTags() {
        TAG_MAP.clear();
        for (Map.Entry<class_6862<class_3611>, Integer> entry : TAGS_TO_LOAD.entrySet()) {
            Integer hardness = entry.getValue();
            for (class_6880 holder : class_7923.field_41173.method_40286(entry.getKey())) {
                TAG_MAP.put((class_3611)holder.comp_349(), hardness);
            }
        }
        TAGS_TO_LOAD.clear();
    }

    public static int getCastingTime(class_3611 fluid) {
        if (FLUID_MAP.containsKey(fluid)) {
            return FLUID_MAP.get(fluid);
        }
        if (TAG_MAP.containsKey(fluid)) {
            return TAG_MAP.get(fluid);
        }
        return 1000;
    }

    public static void writeBuf(class_2540 buf) {
        buf.method_10804(FLUID_MAP.size());
        for (Map.Entry<class_3611, Integer> entry : FLUID_MAP.entrySet()) {
            buf.method_10812(class_7923.field_41173.method_10221((Object)entry.getKey())).method_10804(entry.getValue().intValue());
        }
        buf.method_10804(TAG_MAP.size());
        for (Map.Entry<class_3611, Integer> entry : TAG_MAP.entrySet()) {
            buf.method_10812(class_7923.field_41173.method_10221((Object)entry.getKey())).method_10804(entry.getValue().intValue());
        }
    }

    public static void readBuf(class_2540 buf) {
        FluidCastingTimeHandler.clear();
        int sz = buf.method_10816();
        for (int i = 0; i < sz; ++i) {
            class_2960 id = buf.method_10810();
            int castingTime = buf.method_10816();
            Optional op = class_7923.field_41173.method_17966(id);
            if (op.isEmpty()) continue;
            FLUID_MAP.put((class_3611)op.get(), castingTime);
        }
        int sz1 = buf.method_10816();
        for (int i = 0; i < sz1; ++i) {
            class_2960 id = buf.method_10810();
            int castingTime = buf.method_10816();
            Optional op = class_7923.field_41173.method_17966(id);
            if (op.isEmpty()) continue;
            TAG_MAP.put((class_3611)op.get(), castingTime);
        }
    }

    public static void syncTo(class_3222 player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundFluidCastingTimePacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundFluidCastingTimePacket(), server);
    }

    public record ClientboundFluidCastingTimePacket(@Nullable class_2540 buf) implements RootPacket
    {
        public ClientboundFluidCastingTimePacket() {
            this(null);
        }

        public static ClientboundFluidCastingTimePacket copyOf(class_2540 buf) {
            return new ClientboundFluidCastingTimePacket(new class_2540(buf.copy()));
        }

        @Override
        public void rootEncode(class_2540 buf) {
            FluidCastingTimeHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, class_2547 listener, @Nullable class_3222 sender) {
            if (this.buf != null) {
                FluidCastingTimeHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        public ReloadListener() {
            super(GSON, "fluid_casting_time");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resources, class_3695 profiler) {
            FluidCastingTimeHandler.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                JsonObject obj = el.getAsJsonObject();
                int castingTime = class_3518.method_15282((JsonObject)obj, (String)"casting_time", (int)1000);
                castingTime = Math.max(castingTime, 0);
                class_2960 loc = entry.getKey();
                if (loc.method_12832().startsWith("tags/")) {
                    class_6862 tag = class_6862.method_40092((class_5321)class_7923.field_41173.method_30517(), (class_2960)new class_2960(loc.method_12836(), loc.method_12832().substring(5)));
                    TAGS_TO_LOAD.put((class_6862<class_3611>)tag, castingTime);
                    continue;
                }
                class_3611 fluid = (class_3611)class_7923.field_41173.method_17966(loc).orElseThrow(() -> new JsonSyntaxException("Unknown fluid type '" + loc + "'"));
                FLUID_MAP.put(fluid, castingTime);
            }
        }
    }
}

