/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import rbasamoyai.createbigcannons.base.BlockStatePredicateHelper;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.ICannonContraptionType;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountBlockPropertiesProvider;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountBlockPropertiesSerializer;
import rbasamoyai.createbigcannons.cannon_control.config.GeneralMountProperties;

public record SimpleBlockMountProperties(GeneralMountProperties defaultProperties, Map<class_2680, GeneralMountProperties> propertiesByState) implements CannonMountBlockPropertiesProvider
{
    @Override
    public float maximumElevation(class_1937 level, class_2680 state, class_2338 pos) {
        return this.propertiesByState.getOrDefault(state, this.defaultProperties).maximumElevation();
    }

    @Override
    public float maximumDepression(class_1937 level, class_2680 state, class_2338 pos) {
        return this.propertiesByState.getOrDefault(state, this.defaultProperties).maximumDepression();
    }

    public static class Serializer
    implements CannonMountBlockPropertiesSerializer<SimpleBlockMountProperties> {
        @Override
        public SimpleBlockMountProperties fromJson(class_2591<?> beType, ICannonContraptionType contraptionType, JsonObject obj) {
            Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
            for (class_2248 block : beType.field_19315) {
                class_2960 blockLoc = class_7923.field_41175.method_10221((Object)block);
                String blockKey = blockLoc.toString();
                if (!obj.has(blockKey) && !obj.get(blockKey).isJsonObject()) continue;
                JsonObject variantsOfBlock = obj.getAsJsonObject(blockKey);
                class_2689 definition = block.method_9595();
                HashSet blockStates = new HashSet(definition.method_11662());
                for (String variantKey : variantsOfBlock.keySet()) {
                    Predicate<class_2680> pred = BlockStatePredicateHelper.variantPredicate((class_2689<class_2248, class_2680>)definition, variantKey);
                    JsonElement variantEl = variantsOfBlock.get(variantKey);
                    if (!variantEl.isJsonObject()) {
                        throw new JsonSyntaxException("Invalid info for variant '" + variantKey + "''");
                    }
                    JsonObject variantInfo = variantEl.getAsJsonObject();
                    GeneralMountProperties properties = GeneralMountProperties.fromJson(variantInfo);
                    Iterator stateIter = blockStates.iterator();
                    while (stateIter.hasNext()) {
                        class_2680 state = (class_2680)stateIter.next();
                        if (!pred.test(state)) continue;
                        propertiesByState.put(state, properties);
                        stateIter.remove();
                    }
                }
            }
            GeneralMountProperties defaultProperties = GeneralMountProperties.fromJson(obj);
            return new SimpleBlockMountProperties(defaultProperties, (Map<class_2680, GeneralMountProperties>)propertiesByState);
        }

        @Override
        public void toNetwork(SimpleBlockMountProperties properties, class_2540 buf) {
            properties.defaultProperties.toNetwork(buf);
            buf.method_10804(properties.propertiesByState.size());
            for (Map.Entry<class_2680, GeneralMountProperties> entry : properties.propertiesByState.entrySet()) {
                buf.method_10804(class_2248.method_9507((class_2680)entry.getKey()));
                entry.getValue().toNetwork(buf);
            }
        }

        @Override
        public SimpleBlockMountProperties fromNetwork(class_2540 buf) {
            GeneralMountProperties defaultProperties = GeneralMountProperties.fromNetwork(buf);
            int sz = buf.method_10816();
            Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
            for (int i = 0; i < sz; ++i) {
                class_2680 state = class_2248.method_9531((int)buf.method_10816());
                GeneralMountProperties properties = GeneralMountProperties.fromNetwork(buf);
                propertiesByState.put(state, properties);
            }
            return new SimpleBlockMountProperties(defaultProperties, (Map<class_2680, GeneralMountProperties>)propertiesByState);
        }
    }
}

