/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt.custom;

import de.bluecolored.shadow.querz.nbt.ByteArrayTag;
import de.bluecolored.shadow.querz.nbt.ByteTag;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import de.bluecolored.shadow.querz.nbt.DoubleTag;
import de.bluecolored.shadow.querz.nbt.FloatTag;
import de.bluecolored.shadow.querz.nbt.IntArrayTag;
import de.bluecolored.shadow.querz.nbt.IntTag;
import de.bluecolored.shadow.querz.nbt.ListTag;
import de.bluecolored.shadow.querz.nbt.LongArrayTag;
import de.bluecolored.shadow.querz.nbt.LongTag;
import de.bluecolored.shadow.querz.nbt.ShortTag;
import de.bluecolored.shadow.querz.nbt.StringTag;
import de.bluecolored.shadow.querz.nbt.Tag;
import de.bluecolored.shadow.querz.nbt.TagFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class StructTag
extends Tag<List<Tag<?>>>
implements Iterable<Tag<?>>,
Comparable<StructTag> {
    public static void register() {
        TagFactory.registerCustomTag(120, StructTag::new, StructTag.class);
    }

    public StructTag() {
        super(StructTag.createEmptyValue());
    }

    private static List<Tag<?>> createEmptyValue() {
        return new ArrayList(3);
    }

    public int size() {
        return ((List)this.getValue()).size();
    }

    public Tag<?> remove(int index) {
        return (Tag)((List)this.getValue()).remove(index);
    }

    public boolean remove(Tag<?> tag) {
        return ((List)this.getValue()).remove(tag);
    }

    public void clear() {
        ((List)this.getValue()).clear();
    }

    public boolean contains(Tag<?> tag) {
        return ((List)this.getValue()).contains(tag);
    }

    public boolean containsAll(Collection<Tag<?>> tags) {
        return ((List)this.getValue()).containsAll(tags);
    }

    @Override
    public Iterator<Tag<?>> iterator() {
        return ((List)this.getValue()).iterator();
    }

    @Override
    public void forEach(Consumer<? super Tag<?>> action) {
        ((List)this.getValue()).forEach(action);
    }

    public <S extends Tag<?>> S get(int index, Class<S> type) {
        Tag t = (Tag)((List)this.getValue()).get(index);
        return (S)((Tag)type.cast(t));
    }

    public Tag<?> get(int index) {
        return (Tag)((List)this.getValue()).get(index);
    }

    public ByteTag getByteTag(int index) {
        return this.get(index, ByteTag.class);
    }

    public ShortTag getShortTag(int index) {
        return this.get(index, ShortTag.class);
    }

    public IntTag getIntTag(int index) {
        return this.get(index, IntTag.class);
    }

    public LongTag getLongTag(int index) {
        return this.get(index, LongTag.class);
    }

    public FloatTag getFloatTag(int index) {
        return this.get(index, FloatTag.class);
    }

    public DoubleTag getDoubleTag(int index) {
        return this.get(index, DoubleTag.class);
    }

    public StringTag getStringTag(int index) {
        return this.get(index, StringTag.class);
    }

    public ByteArrayTag getByteArrayTag(int index) {
        return this.get(index, ByteArrayTag.class);
    }

    public IntArrayTag getIntArrayTag(int index) {
        return this.get(index, IntArrayTag.class);
    }

    public LongArrayTag getLongArrayTag(int index) {
        return this.get(index, LongArrayTag.class);
    }

    public ListTag<?> getListTag(int index) {
        return this.get(index, ListTag.class);
    }

    public CompoundTag getCompoundTag(int index) {
        return this.get(index, CompoundTag.class);
    }

    public boolean getBoolean(int index) {
        Tag<?> t = this.get(index);
        return t instanceof ByteTag && ((ByteTag)t).asByte() > 0;
    }

    public byte getByte(int index) {
        return this.getByteTag(index).asByte();
    }

    public short getShort(int index) {
        return this.getShortTag(index).asShort();
    }

    public int getInt(int index) {
        return this.getIntTag(index).asInt();
    }

    public long getLong(int index) {
        return this.getLongTag(index).asLong();
    }

    public float getFloat(int index) {
        return this.getFloatTag(index).asFloat();
    }

    public double getDouble(int index) {
        return this.getDoubleTag(index).asDouble();
    }

    public String getString(int index) {
        return this.getStringTag(index).getValue();
    }

    public byte[] getByteArray(int index) {
        return (byte[])this.getByteArrayTag(index).getValue();
    }

    public int[] getIntArray(int index) {
        return (int[])this.getIntArrayTag(index).getValue();
    }

    public long[] getLongArray(int index) {
        return (long[])this.getLongArrayTag(index).getValue();
    }

    public Tag<?> set(int index, Tag<?> tag) {
        return ((List)this.getValue()).set(index, Objects.requireNonNull(tag));
    }

    public void add(Tag<?> tag) {
        ((List)this.getValue()).add(Objects.requireNonNull(tag));
    }

    public void add(int index, Tag<?> tag) {
        ((List)this.getValue()).add(index, Objects.requireNonNull(tag));
    }

    public void addBoolean(boolean value) {
        this.add(new ByteTag(value));
    }

    public void addByte(byte value) {
        this.add(new ByteTag(value));
    }

    public void addShort(short value) {
        this.add(new ShortTag(value));
    }

    public void addInt(int value) {
        this.add(new IntTag(value));
    }

    public void addLong(long value) {
        this.add(new LongTag(value));
    }

    public void addFloat(float value) {
        this.add(new FloatTag(value));
    }

    public void addDouble(double value) {
        this.add(new DoubleTag(value));
    }

    public void addString(String value) {
        this.add(new StringTag(value));
    }

    public void addByteArray(byte[] value) {
        this.add(new ByteArrayTag(value));
    }

    public void addIntArray(int[] value) {
        this.add(new IntArrayTag(value));
    }

    public void addLongArray(long[] value) {
        this.add(new LongArrayTag(value));
    }

    @Override
    public void serializeValue(DataOutputStream dos, int maxDepth) throws IOException {
        dos.writeInt(this.size());
        for (Tag tag : (List)this.getValue()) {
            dos.writeByte(tag.getID());
            tag.serializeValue(dos, this.decrementMaxDepth(maxDepth));
        }
    }

    @Override
    public void deserializeValue(DataInputStream dis, int maxDepth) throws IOException {
        int size = dis.readInt();
        size = size < 0 ? 0 : size;
        this.setValue(new ArrayList(size));
        for (int i = 0; i < size; ++i) {
            Tag<?> tag = TagFactory.fromID(dis.readByte());
            tag.deserializeValue(dis, this.decrementMaxDepth(maxDepth));
            this.add(tag);
        }
    }

    @Override
    public String valueToString(int maxDepth) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(i > 0 ? "," : "").append(this.get(i).toString(this.decrementMaxDepth(maxDepth)));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String valueToTagString(int maxDepth) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(i > 0 ? "," : "").append(this.get(i).valueToTagString(this.decrementMaxDepth(maxDepth)));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || this.size() != ((StructTag)other).size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(((StructTag)other).get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((List)this.getValue()).hashCode();
    }

    @Override
    public int compareTo(StructTag o) {
        return Integer.compare(this.size(), o.size());
    }

    @Override
    public StructTag clone() {
        StructTag copy = new StructTag();
        for (Tag tag : (List)this.getValue()) {
            copy.add((Tag<?>)tag.clone());
        }
        return copy;
    }
}

