/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt;

import de.bluecolored.shadow.querz.nbt.ByteArrayTag;
import de.bluecolored.shadow.querz.nbt.ByteTag;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import de.bluecolored.shadow.querz.nbt.DoubleTag;
import de.bluecolored.shadow.querz.nbt.EndTag;
import de.bluecolored.shadow.querz.nbt.FloatTag;
import de.bluecolored.shadow.querz.nbt.IntArrayTag;
import de.bluecolored.shadow.querz.nbt.IntTag;
import de.bluecolored.shadow.querz.nbt.ListTag;
import de.bluecolored.shadow.querz.nbt.LongArrayTag;
import de.bluecolored.shadow.querz.nbt.LongTag;
import de.bluecolored.shadow.querz.nbt.ShortTag;
import de.bluecolored.shadow.querz.nbt.StringTag;
import de.bluecolored.shadow.querz.nbt.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class TagFactory {
    private static Map<Integer, TagMapping<?>> idMapping = new HashMap();
    private static Map<Class<?>, TagMapping<?>> classMapping = new HashMap();

    private static <T extends Tag<?>> void put(int id, Supplier<T> factory, Class<T> clazz) {
        TagMapping<T> mapping = new TagMapping<T>(id, factory, clazz);
        idMapping.put(id, mapping);
        classMapping.put(clazz, mapping);
    }

    private TagFactory() {
    }

    public static Tag<?> fromID(int id) {
        TagMapping<?> mapping = idMapping.get(id);
        if (mapping == null) {
            throw new IllegalArgumentException("unknown Tag id " + id);
        }
        return (Tag)((TagMapping)mapping).factory.get();
    }

    public static Class<?> classFromID(int id) {
        TagMapping<?> mapping = idMapping.get(id);
        if (mapping == null) {
            throw new IllegalArgumentException("unknown Tag id " + id);
        }
        return ((TagMapping)mapping).clazz;
    }

    public static byte idFromClass(Class<?> clazz) {
        TagMapping<?> mapping = classMapping.get(clazz);
        if (mapping == null) {
            throw new IllegalArgumentException("unknown Tag class " + clazz.getName());
        }
        return (byte)((TagMapping)mapping).id;
    }

    public static <T extends Tag<?>> void registerCustomTag(int id, Supplier<T> factory, Class<T> clazz) {
        TagFactory.checkID(id);
        if (idMapping.containsKey(id)) {
            throw new IllegalArgumentException("custom tag already registered");
        }
        TagFactory.put(id, factory, clazz);
    }

    public static void unregisterCustomTag(int id) {
        idMapping.remove(id);
        for (TagMapping<?> mapping : classMapping.values()) {
            if (((TagMapping)mapping).id != id) continue;
            classMapping.remove(((TagMapping)mapping).clazz);
            return;
        }
    }

    private static void checkID(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id cannot be negative");
        }
        if (id <= 12) {
            throw new IllegalArgumentException("cannot change default tags");
        }
        if (id > 127) {
            throw new IllegalArgumentException("id out of bounds: " + id);
        }
    }

    static {
        TagFactory.put(0, () -> EndTag.INSTANCE, EndTag.class);
        TagFactory.put(1, ByteTag::new, ByteTag.class);
        TagFactory.put(2, ShortTag::new, ShortTag.class);
        TagFactory.put(3, IntTag::new, IntTag.class);
        TagFactory.put(4, LongTag::new, LongTag.class);
        TagFactory.put(5, FloatTag::new, FloatTag.class);
        TagFactory.put(6, DoubleTag::new, DoubleTag.class);
        TagFactory.put(7, ByteArrayTag::new, ByteArrayTag.class);
        TagFactory.put(8, StringTag::new, StringTag.class);
        TagFactory.put(9, ListTag::createUnchecked, ListTag.class);
        TagFactory.put(10, CompoundTag::new, CompoundTag.class);
        TagFactory.put(11, IntArrayTag::new, IntArrayTag.class);
        TagFactory.put(12, LongArrayTag::new, LongArrayTag.class);
    }

    private static class TagMapping<T extends Tag<?>> {
        private int id;
        private Supplier<T> factory;
        private Class<T> clazz;

        TagMapping(int id, Supplier<T> factory, Class<T> clazz) {
            this.id = id;
            this.factory = factory;
            this.clazz = clazz;
        }
    }
}

