/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt;

import de.bluecolored.shadow.querz.nbt.MaxDepthReachedException;
import de.bluecolored.shadow.querz.nbt.TagFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Tag<T>
implements Cloneable {
    public static final int DEFAULT_MAX_DEPTH = 512;
    private static final Map<String, String> ESCAPE_CHARACTERS;
    private static final Pattern ESCAPE_PATTERN;
    private static final Pattern NON_QUOTE_PATTERN;
    private T value;

    public Tag(T value) {
        this.setValue(value);
    }

    public byte getID() {
        return TagFactory.idFromClass(this.getClass());
    }

    protected T getValue() {
        return this.value;
    }

    protected void setValue(T value) {
        this.value = this.checkValue(value);
    }

    protected T checkValue(T value) {
        return Objects.requireNonNull(value);
    }

    public final void serialize(DataOutputStream dos, int maxDepth) throws IOException {
        this.serialize(dos, "", maxDepth);
    }

    public final void serialize(DataOutputStream dos, String name, int maxDepth) throws IOException {
        dos.writeByte(this.getID());
        if (this.getID() != 0) {
            dos.writeUTF(name);
        }
        this.serializeValue(dos, maxDepth);
    }

    public static Tag<?> deserialize(DataInputStream dis, int maxDepth) throws IOException {
        int id = dis.readByte() & 0xFF;
        Tag<?> tag = TagFactory.fromID(id);
        if (id != 0) {
            dis.readUTF();
            tag.deserializeValue(dis, maxDepth);
        }
        return tag;
    }

    public abstract void serializeValue(DataOutputStream var1, int var2) throws IOException;

    public abstract void deserializeValue(DataInputStream var1, int var2) throws IOException;

    public final String toString() {
        return this.toString(512);
    }

    public String toString(int maxDepth) {
        return "{\"type\":\"" + this.getClass().getSimpleName() + "\",\"value\":" + this.valueToString(maxDepth) + "}";
    }

    public abstract String valueToString(int var1);

    public final String toTagString() {
        return this.toTagString(512);
    }

    public String toTagString(int maxDepth) {
        return this.valueToTagString(maxDepth);
    }

    public abstract String valueToTagString(int var1);

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public abstract Tag<T> clone();

    protected int decrementMaxDepth(int maxDepth) {
        if (maxDepth < 0) {
            throw new IllegalArgumentException("negative maximum depth is not allowed");
        }
        if (maxDepth == 0) {
            throw new MaxDepthReachedException("reached maximum depth of NBT structure");
        }
        return --maxDepth;
    }

    protected static String escapeString(String s2, boolean lenient) {
        StringBuffer sb = new StringBuffer();
        Matcher m3 = ESCAPE_PATTERN.matcher(s2);
        while (m3.find()) {
            m3.appendReplacement(sb, ESCAPE_CHARACTERS.get(m3.group()));
        }
        m3.appendTail(sb);
        m3 = NON_QUOTE_PATTERN.matcher(s2);
        if (!lenient || !m3.matches()) {
            sb.insert(0, "\"").append("\"");
        }
        return sb.toString();
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("\\", "\\\\\\\\");
        temp.put("\n", "\\\\n");
        temp.put("\t", "\\\\t");
        temp.put("\r", "\\\\r");
        temp.put("\"", "\\\\\"");
        ESCAPE_CHARACTERS = Collections.unmodifiableMap(temp);
        ESCAPE_PATTERN = Pattern.compile("[\\\\\n\t\r\"]");
        NON_QUOTE_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-+]+");
    }
}

