/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt;

import de.bluecolored.shadow.querz.nbt.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class NBTUtil {
    private NBTUtil() {
    }

    public static void writeTag(Tag<?> tag, String file) throws IOException {
        NBTUtil.writeTag(tag, "", new File(file), true);
    }

    public static void writeTag(Tag<?> tag, File file) throws IOException {
        NBTUtil.writeTag(tag, "", file, true);
    }

    public static void writeTag(Tag<?> tag, String file, boolean compressed) throws IOException {
        NBTUtil.writeTag(tag, "", new File(file), compressed);
    }

    public static void writeTag(Tag<?> tag, File file, boolean compressed) throws IOException {
        NBTUtil.writeTag(tag, "", file, compressed);
    }

    public static void writeTag(Tag<?> tag, String name, String file) throws IOException {
        NBTUtil.writeTag(tag, name, new File(file), true);
    }

    public static void writeTag(Tag<?> tag, String name, File file) throws IOException {
        NBTUtil.writeTag(tag, name, file, true);
    }

    public static void writeTag(Tag<?> tag, String name, String file, boolean compressed) throws IOException {
        NBTUtil.writeTag(tag, name, new File(file), compressed);
    }

    public static void writeTag(Tag<?> tag, String name, File file, boolean compressed) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(compressed ? new GZIPOutputStream(new FileOutputStream(file)) : new FileOutputStream(file));){
            tag.serialize(dos, name, 512);
        }
    }

    public static Tag<?> readTag(String file) throws IOException {
        return NBTUtil.readTag(new File(file));
    }

    public static Tag<?> readTag(File file) throws IOException {
        try (DataInputStream dis = new DataInputStream(NBTUtil.applyDecompression(new FileInputStream(file)));){
            Tag<?> tag = Tag.deserialize(dis, 512);
            return tag;
        }
    }

    static InputStream applyDecompression(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 2);
        int sig = (pbis.read() & 0xFF) + (pbis.read() << 8);
        pbis.unread(sig >> 8);
        pbis.unread(sig & 0xFF);
        if (sig == 35615) {
            return new GZIPInputStream(pbis);
        }
        return pbis;
    }
}

