/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt;

import de.bluecolored.shadow.querz.nbt.ArrayTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class LongArrayTag
extends ArrayTag<long[]>
implements Comparable<LongArrayTag> {
    public static final long[] ZERO_VALUE = new long[0];

    public LongArrayTag() {
        super(ZERO_VALUE);
    }

    public LongArrayTag(long[] value) {
        super(value);
    }

    @Override
    public void serializeValue(DataOutputStream dos, int maxDepth) throws IOException {
        dos.writeInt(this.length());
        for (long i : (long[])this.getValue()) {
            dos.writeLong(i);
        }
    }

    @Override
    public void deserializeValue(DataInputStream dis, int maxDepth) throws IOException {
        int length = dis.readInt();
        this.setValue(new long[length]);
        for (int i = 0; i < length; ++i) {
            ((long[])this.getValue())[i] = dis.readLong();
        }
    }

    @Override
    public String valueToTagString(int maxDepth) {
        return this.arrayToString("L", "l");
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Arrays.equals((long[])this.getValue(), (long[])((LongArrayTag)other).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((long[])this.getValue());
    }

    @Override
    public int compareTo(LongArrayTag other) {
        return Integer.compare(this.length(), other.length());
    }

    @Override
    public LongArrayTag clone() {
        return new LongArrayTag(Arrays.copyOf((long[])this.getValue(), this.length()));
    }
}

