/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.querz.nbt;

import de.bluecolored.shadow.querz.nbt.ArrayTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class IntArrayTag
extends ArrayTag<int[]>
implements Comparable<IntArrayTag> {
    public static final int[] ZERO_VALUE = new int[0];

    public IntArrayTag() {
        super(ZERO_VALUE);
    }

    public IntArrayTag(int[] value) {
        super(value);
    }

    @Override
    public void serializeValue(DataOutputStream dos, int maxDepth) throws IOException {
        dos.writeInt(this.length());
        for (int i : (int[])this.getValue()) {
            dos.writeInt(i);
        }
    }

    @Override
    public void deserializeValue(DataInputStream dis, int maxDepth) throws IOException {
        int length = dis.readInt();
        this.setValue(new int[length]);
        for (int i = 0; i < length; ++i) {
            ((int[])this.getValue())[i] = dis.readInt();
        }
    }

    @Override
    public String valueToTagString(int maxDepth) {
        return this.arrayToString("I", "");
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Arrays.equals((int[])this.getValue(), (int[])((IntArrayTag)other).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((int[])this.getValue());
    }

    @Override
    public int compareTo(IntArrayTag other) {
        return Integer.compare(this.length(), other.length());
    }

    @Override
    public IntArrayTag clone() {
        return new IntArrayTag(Arrays.copyOf((int[])this.getValue(), this.length()));
    }
}

