/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.benmanes.caffeine.cache;

import de.bluecolored.shadow.benmanes.caffeine.cache.Policy;
import de.bluecolored.shadow.benmanes.caffeine.cache.stats.CacheStats;
import de.bluecolored.shadow.checkerframework.checker.index.qual.NonNegative;
import de.bluecolored.shadow.checkerframework.checker.nullness.qual.NonNull;
import de.bluecolored.shadow.checkerframework.checker.nullness.qual.Nullable;
import de.bluecolored.shadow.google.errorprone.annotations.CompatibleWith;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public interface Cache<K, V> {
    public @Nullable V getIfPresent(@CompatibleWith(value="K") @NonNull Object var1);

    public @Nullable V get(@NonNull K var1, @NonNull Function<? super K, ? extends V> var2);

    public @NonNull Map<@NonNull K, @NonNull V> getAllPresent(@NonNull Iterable<@NonNull ?> var1);

    default public @NonNull Map<K, V> getAll(@NonNull Iterable<? extends @NonNull K> keys, @NonNull Function<Iterable<? extends @NonNull K>, @NonNull Map<K, V>> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public void put(@NonNull K var1, @NonNull V var2);

    public void putAll(@NonNull Map<? extends @NonNull K, ? extends @NonNull V> var1);

    public void invalidate(@CompatibleWith(value="K") @NonNull Object var1);

    public void invalidateAll(@NonNull Iterable<@NonNull ?> var1);

    public void invalidateAll();

    public @NonNegative long estimatedSize();

    public @NonNull CacheStats stats();

    public @NonNull ConcurrentMap<@NonNull K, @NonNull V> asMap();

    public void cleanUp();

    public @NonNull Policy<K, V> policy();
}

