/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.fabric;

import de.bluecolored.bluemap.common.serverinterface.Dimension;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class FabricWorld
implements ServerWorld {
    private final WeakReference<class_3218> delegate;
    private final Path saveFolder;

    public FabricWorld(class_3218 delegate) {
        this.delegate = new WeakReference<class_3218>(delegate);
        MinecraftServer server = delegate.method_8503();
        Path worldFolder = delegate.method_8503().method_3831().toPath().resolve(server.method_27050(class_5218.field_24188));
        this.saveFolder = class_2874.method_12488((class_5321)delegate.method_27983(), (Path)worldFolder).toAbsolutePath().normalize();
    }

    @Override
    public Dimension getDimension() {
        class_3218 world = (class_3218)this.delegate.get();
        if (world != null) {
            if (world.method_27983().equals(class_1937.field_25180)) {
                return Dimension.NETHER;
            }
            if (world.method_27983().equals(class_1937.field_25181)) {
                return Dimension.END;
            }
            if (world.method_27983().equals(class_1937.field_25179)) {
                return Dimension.OVERWORLD;
            }
        }
        return ServerWorld.super.getDimension();
    }

    @Override
    public boolean persistWorldChanges() throws IOException {
        class_3218 world = (class_3218)this.delegate.get();
        if (world == null) {
            return false;
        }
        CompletableFuture<Boolean> taskResult = CompletableFuture.supplyAsync(() -> {
            try {
                world.method_14176(null, true, false);
                return true;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)world.method_8503());
        try {
            return taskResult.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            throw new IOException(t);
        }
    }

    @Override
    public Path getSaveFolder() {
        return this.saveFolder;
    }
}

