/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.fabric;

import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.fabric.FabricMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class FabricEventForwarder {
    private FabricMod mod;
    private Collection<ServerEventListener> eventListeners;

    public FabricEventForwarder(FabricMod mod) {
        this.mod = mod;
        this.eventListeners = new ArrayList<ServerEventListener>(1);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.onPlayerJoin(server, handler.method_32311()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.onPlayerLeave(server, handler.method_32311()));
    }

    public synchronized void addEventListener(ServerEventListener listener) {
        this.eventListeners.add(listener);
    }

    public synchronized void removeAllListeners() {
        this.eventListeners.clear();
    }

    public synchronized void onPlayerJoin(MinecraftServer server, class_3222 player) {
        if (this.mod.getServer() != server) {
            return;
        }
        UUID uuid = player.method_5667();
        for (ServerEventListener listener : this.eventListeners) {
            listener.onPlayerJoin(uuid);
        }
    }

    public synchronized void onPlayerLeave(MinecraftServer server, class_3222 player) {
        if (this.mod.getServer() != server) {
            return;
        }
        UUID uuid = player.method_5667();
        for (ServerEventListener listener : this.eventListeners) {
            listener.onPlayerLeave(uuid);
        }
    }
}

